/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.ReadOnlyBookmarkHolder;
import org.neo4j.driver.internal.cluster.AbstractRoutingProcedureRunnerTest;
import org.neo4j.driver.internal.cluster.MultiDatabasesRoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.cluster.SingleDatabaseRoutingProcedureRunner;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.util.TestUtil;

class MultiDatabasesRoutingProcedureRunnerTest
extends AbstractRoutingProcedureRunnerTest {
    MultiDatabasesRoutingProcedureRunnerTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"", "system", " this is a db name "})
    void shouldCallGetRoutingTableWithEmptyMapOnSystemDatabaseForDatabase(String db) {
        TestRoutingProcedureRunner runner = new TestRoutingProcedureRunner(RoutingContext.EMPTY);
        RoutingProcedureResponse response = (RoutingProcedureResponse)TestUtil.await(runner.run(MultiDatabasesRoutingProcedureRunnerTest.connection(), DatabaseNameUtil.database((String)db), InternalBookmark.empty(), null));
        Assertions.assertTrue((boolean)response.isSuccess());
        Assertions.assertEquals((int)1, (int)response.records().size());
        MatcherAssert.assertThat((Object)runner.bookmarkHolder, (Matcher)IsInstanceOf.instanceOf(ReadOnlyBookmarkHolder.class));
        MatcherAssert.assertThat((Object)runner.connection.databaseName(), (Matcher)Matchers.equalTo((Object)DatabaseNameUtil.systemDatabase()));
        MatcherAssert.assertThat((Object)runner.connection.mode(), (Matcher)Matchers.equalTo((Object)AccessMode.READ));
        Query query = MultiDatabasesRoutingProcedureRunnerTest.generateMultiDatabaseRoutingQuery(Collections.EMPTY_MAP, db);
        MatcherAssert.assertThat((Object)runner.procedure, (Matcher)Matchers.equalTo((Object)query));
    }

    @ParameterizedTest
    @ValueSource(strings={"", "system", " this is a db name "})
    void shouldCallGetRoutingTableWithParamOnSystemDatabaseForDatabase(String db) {
        URI uri = URI.create("neo4j://localhost/?key1=value1&key2=value2");
        RoutingContext context = new RoutingContext(uri);
        TestRoutingProcedureRunner runner = new TestRoutingProcedureRunner(context);
        RoutingProcedureResponse response = (RoutingProcedureResponse)TestUtil.await(runner.run(MultiDatabasesRoutingProcedureRunnerTest.connection(), DatabaseNameUtil.database((String)db), InternalBookmark.empty(), null));
        Assertions.assertTrue((boolean)response.isSuccess());
        Assertions.assertEquals((int)1, (int)response.records().size());
        MatcherAssert.assertThat((Object)runner.bookmarkHolder, (Matcher)IsInstanceOf.instanceOf(ReadOnlyBookmarkHolder.class));
        MatcherAssert.assertThat((Object)runner.connection.databaseName(), (Matcher)Matchers.equalTo((Object)DatabaseNameUtil.systemDatabase()));
        MatcherAssert.assertThat((Object)runner.connection.mode(), (Matcher)Matchers.equalTo((Object)AccessMode.READ));
        Query query = MultiDatabasesRoutingProcedureRunnerTest.generateMultiDatabaseRoutingQuery(context.toMap(), db);
        MatcherAssert.assertThat((Object)response.procedure(), (Matcher)Matchers.equalTo((Object)query));
        MatcherAssert.assertThat((Object)runner.procedure, (Matcher)Matchers.equalTo((Object)query));
    }

    @Override
    SingleDatabaseRoutingProcedureRunner singleDatabaseRoutingProcedureRunner(RoutingContext context) {
        return new TestRoutingProcedureRunner(context);
    }

    @Override
    SingleDatabaseRoutingProcedureRunner singleDatabaseRoutingProcedureRunner(RoutingContext context, CompletionStage<List<Record>> runProcedureResult) {
        return new TestRoutingProcedureRunner(context, runProcedureResult);
    }

    private static Query generateMultiDatabaseRoutingQuery(Map context, String db) {
        Value parameters = Values.parameters((Object[])new Object[]{"context", context, "database", db});
        return new Query(MultiDatabasesRoutingProcedureRunner.MULTI_DB_GET_ROUTING_TABLE, parameters);
    }

    private static class TestRoutingProcedureRunner
    extends MultiDatabasesRoutingProcedureRunner {
        final CompletionStage<List<Record>> runProcedureResult;
        private Connection connection;
        private Query procedure;
        private BookmarkHolder bookmarkHolder;

        TestRoutingProcedureRunner(RoutingContext context) {
            this(context, CompletableFuture.completedFuture(Collections.singletonList((Record)Mockito.mock(Record.class))));
        }

        TestRoutingProcedureRunner(RoutingContext context, CompletionStage<List<Record>> runProcedureResult) {
            super(context);
            this.runProcedureResult = runProcedureResult;
        }

        CompletionStage<List<Record>> runProcedure(Connection connection, Query procedure, BookmarkHolder bookmarkHolder) {
            this.connection = connection;
            this.procedure = procedure;
            this.bookmarkHolder = bookmarkHolder;
            return this.runProcedureResult;
        }
    }
}

