/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.cluster.RouteMessageRoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.handlers.RouteMessageResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.RouteMessage;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.util.TestUtil;

class RouteMessageRoutingProcedureRunnerTest {
    RouteMessageRoutingProcedureRunnerTest() {
    }

    private static Stream<Arguments> shouldRequestRoutingTableForAllValidInputScenarios() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{RoutingContext.EMPTY, DatabaseNameUtil.defaultDatabase()}), Arguments.arguments((Object[])new Object[]{RoutingContext.EMPTY, DatabaseNameUtil.systemDatabase()}), Arguments.arguments((Object[])new Object[]{RoutingContext.EMPTY, DatabaseNameUtil.database((String)"neo4j")}), Arguments.arguments((Object[])new Object[]{new RoutingContext(URI.create("localhost:17601")), DatabaseNameUtil.defaultDatabase()}), Arguments.arguments((Object[])new Object[]{new RoutingContext(URI.create("localhost:17602")), DatabaseNameUtil.systemDatabase()}), Arguments.arguments((Object[])new Object[]{new RoutingContext(URI.create("localhost:17603")), DatabaseNameUtil.database((String)"neo4j")}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldRequestRoutingTableForAllValidInputScenarios(RoutingContext routingContext, DatabaseName databaseName) {
        Map<String, Value> routingTable = this.getRoutingTable();
        CompletableFuture<Map<String, Value>> completableFuture = CompletableFuture.completedFuture(routingTable);
        RouteMessageRoutingProcedureRunner runner = new RouteMessageRoutingProcedureRunner(routingContext, () -> completableFuture);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        CompletableFuture<Object> releaseConnectionFuture = CompletableFuture.completedFuture(null);
        ((Connection)Mockito.doReturn(releaseConnectionFuture).when((Object)connection)).release();
        RoutingProcedureResponse response = (RoutingProcedureResponse)TestUtil.await(runner.run(connection, databaseName, null, null));
        Assertions.assertNotNull((Object)response);
        Assertions.assertTrue((boolean)response.isSuccess());
        Assertions.assertNotNull((Object)response.procedure());
        Assertions.assertEquals((int)1, (int)response.records().size());
        Assertions.assertNotNull(response.records().get(0));
        Record record = (Record)response.records().get(0);
        Assertions.assertEquals((Object)routingTable.get("ttl"), (Object)record.get("ttl"));
        Assertions.assertEquals((Object)routingTable.get("servers"), (Object)record.get("servers"));
        this.verifyMessageWasWrittenAndFlushed(connection, completableFuture, routingContext, null, databaseName);
        ((Connection)Mockito.verify((Object)connection)).release();
    }

    @Test
    void shouldReturnFailureWhenSomethingHappensGettingTheRoutingTable() {
        RuntimeException reason = new RuntimeException("Some error");
        CompletableFuture<Map<String, Value>> completableFuture = new CompletableFuture<Map<String, Value>>();
        completableFuture.completeExceptionally(reason);
        RouteMessageRoutingProcedureRunner runner = new RouteMessageRoutingProcedureRunner(RoutingContext.EMPTY, () -> completableFuture);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        CompletableFuture<Object> releaseConnectionFuture = CompletableFuture.completedFuture(null);
        ((Connection)Mockito.doReturn(releaseConnectionFuture).when((Object)connection)).release();
        RoutingProcedureResponse response = (RoutingProcedureResponse)TestUtil.await(runner.run(connection, DatabaseNameUtil.defaultDatabase(), null, null));
        Assertions.assertNotNull((Object)response);
        Assertions.assertFalse((boolean)response.isSuccess());
        Assertions.assertNotNull((Object)response.procedure());
        Assertions.assertEquals((Object)reason, (Object)response.error());
        Assertions.assertThrows(IllegalStateException.class, () -> response.records().size());
        this.verifyMessageWasWrittenAndFlushed(connection, completableFuture, RoutingContext.EMPTY, null, DatabaseNameUtil.defaultDatabase());
        ((Connection)Mockito.verify((Object)connection)).release();
    }

    private void verifyMessageWasWrittenAndFlushed(Connection connection, CompletableFuture<Map<String, Value>> completableFuture, RoutingContext routingContext, Bookmark bookmark, DatabaseName databaseName) {
        Map<String, Value> context = routingContext.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Values.value((String)((String)entry.getValue()))));
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new RouteMessage(context, bookmark, (String)databaseName.databaseName().orElse(null), null)), (ResponseHandler)ArgumentMatchers.eq((Object)new RouteMessageResponseHandler(completableFuture)));
    }

    private Map<String, Value> getRoutingTable() {
        HashMap<String, Value> routingTable = new HashMap<String, Value>();
        routingTable.put("ttl", Values.value((int)300));
        routingTable.put("servers", Values.value(this.getServers()));
        return routingTable;
    }

    private List<Map<String, Value>> getServers() {
        ArrayList<Map<String, Value>> servers = new ArrayList<Map<String, Value>>();
        servers.add(this.getServer("WRITE", "localhost:17601"));
        servers.add(this.getServer("READ", "localhost:17601", "localhost:17602", "localhost:17603"));
        servers.add(this.getServer("ROUTE", "localhost:17601", "localhost:17602", "localhost:17603"));
        return servers;
    }

    private Map<String, Value> getServer(String role, String ... addresses) {
        HashMap<String, Value> server = new HashMap<String, Value>();
        server.put("role", Values.value((String)role));
        server.put("addresses", Values.value((String[])addresses));
        return server;
    }
}

