/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.cluster.RoutingContext;

class RoutingContextTest {
    RoutingContextTest() {
    }

    @Test
    void emptyContextIsNotDefined() {
        Assertions.assertFalse((boolean)RoutingContext.EMPTY.isDefined());
    }

    @Test
    void emptyContextInEmptyMap() {
        Assertions.assertTrue((boolean)RoutingContext.EMPTY.toMap().isEmpty());
    }

    @Test
    void uriWithoutQueryIsParsedToEmptyContext() {
        RoutingContextTest.testEmptyRoutingContext(URI.create("neo4j://localhost:7687/"));
    }

    @Test
    void uriWithEmptyQueryIsParsedToEmptyContext() {
        RoutingContextTest.testEmptyRoutingContext(URI.create("neo4j://localhost:7687?"));
        RoutingContextTest.testEmptyRoutingContext(URI.create("neo4j://localhost:7687/?"));
    }

    @Test
    void uriWithQueryIsParsed() {
        URI uri = URI.create("neo4j://localhost:7687/?key1=value1&key2=value2&key3=value3");
        RoutingContext context = new RoutingContext(uri);
        Assertions.assertTrue((boolean)context.isDefined());
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put("key1", "value1");
        expectedMap.put("key2", "value2");
        expectedMap.put("key3", "value3");
        expectedMap.put("address", "localhost:7687");
        Assertions.assertEquals(expectedMap, (Object)context.toMap());
    }

    @Test
    void boltUriDisablesServerSideRouting() {
        URI uri = URI.create("bolt://localhost:7687/?key1=value1&key2=value2&key3=value3");
        RoutingContext context = new RoutingContext(uri);
        Assertions.assertEquals((Object)false, (Object)context.isServerRoutingEnabled());
    }

    @Test
    void neo4jUriEnablesServerSideRouting() {
        URI uri = URI.create("neo4j://localhost:7687/?key1=value1&key2=value2&key3=value3");
        RoutingContext context = new RoutingContext(uri);
        Assertions.assertEquals((Object)true, (Object)context.isServerRoutingEnabled());
    }

    @Test
    void throwsForInvalidUriQuery() {
        RoutingContextTest.testIllegalUri(URI.create("neo4j://localhost:7687/?justKey"));
    }

    @Test
    void throwsForInvalidUriQueryKey() {
        RoutingContextTest.testIllegalUri(URI.create("neo4j://localhost:7687/?=value1&key2=value2"));
    }

    @Test
    void throwsForInvalidUriQueryValue() {
        RoutingContextTest.testIllegalUri(URI.create("neo4j://localhost:7687/key1?=value1&key2="));
    }

    @Test
    void throwsForDuplicatedUriQueryParameters() {
        RoutingContextTest.testIllegalUri(URI.create("neo4j://localhost:7687/?key1=value1&key2=value2&key1=value2"));
    }

    @Test
    void mapRepresentationIsUnmodifiable() {
        URI uri = URI.create("neo4j://localhost:7687/?key1=value1");
        RoutingContext context = new RoutingContext(uri);
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put("key1", "value1");
        expectedMap.put("address", "localhost:7687");
        Assertions.assertEquals(expectedMap, (Object)context.toMap());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> context.toMap().put("key2", "value2"));
        Assertions.assertEquals(expectedMap, (Object)context.toMap());
    }

    @Test
    void populateAddressWithDefaultPort() {
        URI uri = URI.create("neo4j://localhost/");
        RoutingContext context = new RoutingContext(uri);
        Assertions.assertEquals(Collections.singletonMap("address", "localhost:7687"), (Object)context.toMap());
    }

    @Test
    void throwsExceptionIfAddressIsUsedInContext() {
        URI uri = URI.create("neo4j://localhost:7687/?key1=value1&address=someaddress:9010");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new RoutingContext(uri));
        Assertions.assertEquals((Object)"The key 'address' is reserved for routing context.", (Object)e.getMessage());
    }

    private static void testIllegalUri(URI uri) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RoutingContext(uri));
    }

    private static void testEmptyRoutingContext(URI uri) {
        RoutingContext context = new RoutingContext(uri);
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put("address", "localhost:7687");
        Assertions.assertFalse((boolean)context.isDefined());
        Assertions.assertEquals(Collections.singletonMap("address", "localhost:7687"), (Object)context.toMap());
    }
}

