/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.cluster.AbstractRoutingProcedureRunnerTest;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.cluster.SingleDatabaseRoutingProcedureRunner;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.util.TestUtil;

class SingleDatabaseRoutingProcedureRunnerTest
extends AbstractRoutingProcedureRunnerTest {
    SingleDatabaseRoutingProcedureRunnerTest() {
    }

    @Test
    void shouldCallGetRoutingTableWithEmptyMap() {
        TestRoutingProcedureRunner runner = new TestRoutingProcedureRunner(RoutingContext.EMPTY);
        RoutingProcedureResponse response = (RoutingProcedureResponse)TestUtil.await(runner.run(SingleDatabaseRoutingProcedureRunnerTest.connection(), DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
        Assertions.assertTrue((boolean)response.isSuccess());
        Assertions.assertEquals((int)1, (int)response.records().size());
        MatcherAssert.assertThat((Object)runner.bookmarkHolder, (Matcher)Matchers.equalTo((Object)BookmarkHolder.NO_OP));
        MatcherAssert.assertThat((Object)runner.connection.databaseName(), (Matcher)Matchers.equalTo((Object)DatabaseNameUtil.defaultDatabase()));
        MatcherAssert.assertThat((Object)runner.connection.mode(), (Matcher)Matchers.equalTo((Object)AccessMode.WRITE));
        Query query = SingleDatabaseRoutingProcedureRunnerTest.generateRoutingQuery(Collections.EMPTY_MAP);
        MatcherAssert.assertThat((Object)runner.procedure, (Matcher)Matchers.equalTo((Object)query));
    }

    @Test
    void shouldCallGetRoutingTableWithParam() {
        URI uri = URI.create("neo4j://localhost/?key1=value1&key2=value2");
        RoutingContext context = new RoutingContext(uri);
        TestRoutingProcedureRunner runner = new TestRoutingProcedureRunner(context);
        RoutingProcedureResponse response = (RoutingProcedureResponse)TestUtil.await(runner.run(SingleDatabaseRoutingProcedureRunnerTest.connection(), DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
        Assertions.assertTrue((boolean)response.isSuccess());
        Assertions.assertEquals((int)1, (int)response.records().size());
        MatcherAssert.assertThat((Object)runner.bookmarkHolder, (Matcher)Matchers.equalTo((Object)BookmarkHolder.NO_OP));
        MatcherAssert.assertThat((Object)runner.connection.databaseName(), (Matcher)Matchers.equalTo((Object)DatabaseNameUtil.defaultDatabase()));
        MatcherAssert.assertThat((Object)runner.connection.mode(), (Matcher)Matchers.equalTo((Object)AccessMode.WRITE));
        Query query = SingleDatabaseRoutingProcedureRunnerTest.generateRoutingQuery(context.toMap());
        MatcherAssert.assertThat((Object)response.procedure(), (Matcher)Matchers.equalTo((Object)query));
        MatcherAssert.assertThat((Object)runner.procedure, (Matcher)Matchers.equalTo((Object)query));
    }

    @ParameterizedTest
    @MethodSource(value={"invalidDatabaseNames"})
    void shouldErrorWhenDatabaseIsNotAbsent(String db) throws Throwable {
        TestRoutingProcedureRunner runner = new TestRoutingProcedureRunner(RoutingContext.EMPTY);
        Assertions.assertThrows(FatalDiscoveryException.class, () -> TestUtil.await(runner.run(SingleDatabaseRoutingProcedureRunnerTest.connection(), DatabaseNameUtil.database((String)db), InternalBookmark.empty(), null)));
    }

    @Override
    SingleDatabaseRoutingProcedureRunner singleDatabaseRoutingProcedureRunner(RoutingContext context) {
        return new TestRoutingProcedureRunner(context);
    }

    @Override
    SingleDatabaseRoutingProcedureRunner singleDatabaseRoutingProcedureRunner(RoutingContext context, CompletionStage<List<Record>> runProcedureResult) {
        return new TestRoutingProcedureRunner(context, runProcedureResult);
    }

    private static Stream<String> invalidDatabaseNames() {
        return Stream.of("system", "This is a string", "null");
    }

    private static Query generateRoutingQuery(Map context) {
        Value parameters = Values.parameters((Object[])new Object[]{"context", context});
        return new Query("CALL dbms.cluster.routing.getRoutingTable($context)", parameters);
    }

    private static class TestRoutingProcedureRunner
    extends SingleDatabaseRoutingProcedureRunner {
        final CompletionStage<List<Record>> runProcedureResult;
        private Connection connection;
        private Query procedure;
        private BookmarkHolder bookmarkHolder;

        TestRoutingProcedureRunner(RoutingContext context) {
            this(context, CompletableFuture.completedFuture(Collections.singletonList((Record)Mockito.mock(Record.class))));
        }

        TestRoutingProcedureRunner(RoutingContext context, CompletionStage<List<Record>> runProcedureResult) {
            super(context);
            this.runProcedureResult = runProcedureResult;
        }

        CompletionStage<List<Record>> runProcedure(Connection connection, Query procedure, BookmarkHolder bookmarkHolder) {
            this.connection = connection;
            this.procedure = procedure;
            this.bookmarkHolder = bookmarkHolder;
            return this.runProcedureResult;
        }
    }
}

