/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import io.netty.bootstrap.Bootstrap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.async.pool.NettyChannelHealthChecker;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.async.pool.TestConnectionPool;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionLookupResult;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RediscoveryUtil;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.cluster.RoutingTableRegistryImpl;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancer;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.metrics.DevNullMetricsListener;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.util.TestUtil;

class RoutingTableAndConnectionPoolTest {
    private static final BoltServerAddress A = new BoltServerAddress("localhost:30000");
    private static final BoltServerAddress B = new BoltServerAddress("localhost:30001");
    private static final BoltServerAddress C = new BoltServerAddress("localhost:30002");
    private static final BoltServerAddress D = new BoltServerAddress("localhost:30003");
    private static final BoltServerAddress E = new BoltServerAddress("localhost:30004");
    private static final BoltServerAddress F = new BoltServerAddress("localhost:30005");
    private static final List<BoltServerAddress> SERVERS = Collections.synchronizedList(new LinkedList<BoltServerAddress>(Arrays.asList(null, A, B, C, D, E, F)));
    private static final String[] DATABASES = new String[]{"", "system", "my database"};
    private final Random random = new Random();
    private final Clock clock = Clock.SYSTEM;
    private final Logging logging = Logging.none();

    RoutingTableAndConnectionPoolTest() {
    }

    @Test
    void shouldAddServerToRoutingTableAndConnectionPool() {
        ConnectionPool connectionPool = this.newConnectionPool();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.clusterComposition(A));
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(connectionPool, rediscovery);
        LoadBalancer loadBalancer = this.newLoadBalancer(connectionPool, (RoutingTableRegistry)routingTables);
        TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("neo4j")));
        MatcherAssert.assertThat((Object)routingTables.allServers().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assertions.assertTrue((boolean)routingTables.allServers().contains(A));
        Assertions.assertTrue((boolean)routingTables.contains(DatabaseNameUtil.database((String)"neo4j")));
        Assertions.assertTrue((boolean)connectionPool.isOpen(A));
    }

    @Test
    void shouldNotAddToRoutingTableWhenFailedWithRoutingError() {
        ConnectionPool connectionPool = this.newConnectionPool();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.failedFuture((Throwable)new FatalDiscoveryException("No database found")));
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(connectionPool, rediscovery);
        LoadBalancer loadBalancer = this.newLoadBalancer(connectionPool, (RoutingTableRegistry)routingTables);
        Assertions.assertThrows(FatalDiscoveryException.class, () -> TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("neo4j"))));
        Assertions.assertTrue((boolean)routingTables.allServers().isEmpty());
        Assertions.assertFalse((boolean)routingTables.contains(DatabaseNameUtil.database((String)"neo4j")));
        Assertions.assertFalse((boolean)connectionPool.isOpen(A));
    }

    @Test
    void shouldNotAddToRoutingTableWhenFailedWithProtocolError() {
        ConnectionPool connectionPool = this.newConnectionPool();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.failedFuture((Throwable)new ProtocolException("No database found")));
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(connectionPool, rediscovery);
        LoadBalancer loadBalancer = this.newLoadBalancer(connectionPool, (RoutingTableRegistry)routingTables);
        Assertions.assertThrows(ProtocolException.class, () -> TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("neo4j"))));
        Assertions.assertTrue((boolean)routingTables.allServers().isEmpty());
        Assertions.assertFalse((boolean)routingTables.contains(DatabaseNameUtil.database((String)"neo4j")));
        Assertions.assertFalse((boolean)connectionPool.isOpen(A));
    }

    @Test
    void shouldNotAddToRoutingTableWhenFailedWithSecurityError() {
        ConnectionPool connectionPool = this.newConnectionPool();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.failedFuture((Throwable)new SecurityException("No database found")));
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(connectionPool, rediscovery);
        LoadBalancer loadBalancer = this.newLoadBalancer(connectionPool, (RoutingTableRegistry)routingTables);
        Assertions.assertThrows(SecurityException.class, () -> TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("neo4j"))));
        Assertions.assertTrue((boolean)routingTables.allServers().isEmpty());
        Assertions.assertFalse((boolean)routingTables.contains(DatabaseNameUtil.database((String)"neo4j")));
        Assertions.assertFalse((boolean)connectionPool.isOpen(A));
    }

    @Test
    void shouldNotRemoveNewlyAddedRoutingTableEvenIfItIsExpired() {
        ConnectionPool connectionPool = this.newConnectionPool();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.expiredClusterComposition(A));
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(connectionPool, rediscovery);
        LoadBalancer loadBalancer = this.newLoadBalancer(connectionPool, (RoutingTableRegistry)routingTables);
        Connection connection = (Connection)TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("neo4j")));
        TestUtil.await(connection.release());
        Assertions.assertTrue((boolean)routingTables.contains(DatabaseNameUtil.database((String)"neo4j")));
        MatcherAssert.assertThat((Object)routingTables.allServers().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assertions.assertTrue((boolean)routingTables.allServers().contains(A));
        Assertions.assertTrue((boolean)connectionPool.isOpen(A));
    }

    @Test
    void shouldRemoveExpiredRoutingTableAndServers() {
        ConnectionPool connectionPool = this.newConnectionPool();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.expiredClusterComposition(A)).thenReturn(this.clusterComposition(B));
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(connectionPool, rediscovery);
        LoadBalancer loadBalancer = this.newLoadBalancer(connectionPool, (RoutingTableRegistry)routingTables);
        Connection connection = (Connection)TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("neo4j")));
        TestUtil.await(connection.release());
        TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("foo")));
        Assertions.assertFalse((boolean)routingTables.contains(DatabaseNameUtil.database((String)"neo4j")));
        Assertions.assertTrue((boolean)routingTables.contains(DatabaseNameUtil.database((String)"foo")));
        MatcherAssert.assertThat((Object)routingTables.allServers().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assertions.assertTrue((boolean)routingTables.allServers().contains(B));
        Assertions.assertTrue((boolean)connectionPool.isOpen(B));
    }

    @Test
    void shouldRemoveExpiredRoutingTableButNotServer() {
        ConnectionPool connectionPool = this.newConnectionPool();
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.expiredClusterComposition(A)).thenReturn(this.clusterComposition(B));
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(connectionPool, rediscovery);
        LoadBalancer loadBalancer = this.newLoadBalancer(connectionPool, (RoutingTableRegistry)routingTables);
        TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("neo4j")));
        TestUtil.await(loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase("foo")));
        MatcherAssert.assertThat((Object)routingTables.allServers().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assertions.assertTrue((boolean)routingTables.allServers().contains(B));
        Assertions.assertTrue((boolean)connectionPool.isOpen(B));
        Assertions.assertFalse((boolean)routingTables.contains(DatabaseNameUtil.database((String)"neo4j")));
        Assertions.assertTrue((boolean)routingTables.contains(DatabaseNameUtil.database((String)"foo")));
        Assertions.assertTrue((boolean)connectionPool.isOpen(A));
    }

    @Test
    void shouldHandleAddAndRemoveFromRoutingTableAndConnectionPool() throws Throwable {
        ConnectionPool connectionPool = this.newConnectionPool();
        RandomizedRediscovery rediscovery = new RandomizedRediscovery();
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(connectionPool, rediscovery);
        LoadBalancer loadBalancer = this.newLoadBalancer(connectionPool, (RoutingTableRegistry)routingTables);
        this.acquireAndReleaseConnections(loadBalancer);
        Set servers = routingTables.allServers();
        BoltServerAddress openServer = null;
        for (BoltServerAddress server : servers) {
            if (!connectionPool.isOpen(server)) continue;
            openServer = server;
            break;
        }
        Assertions.assertNotNull((Object)servers);
        SERVERS.remove(openServer);
        Arrays.stream(DATABASES).map(DatabaseNameUtil::database).forEach(arg_0 -> ((RoutingTableRegistry)routingTables).remove(arg_0));
        this.acquireAndReleaseConnections(loadBalancer);
        Assertions.assertFalse((boolean)connectionPool.isOpen(openServer));
    }

    private void acquireAndReleaseConnections(LoadBalancer loadBalancer) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        int count = 100;
        Future[] futures = new Future[count];
        for (int i = 0; i < count; ++i) {
            Future<?> future;
            futures[i] = future = executorService.submit(() -> {
                int index = this.random.nextInt(DATABASES.length);
                CompletionStage task = loadBalancer.acquireConnection(RediscoveryUtil.contextWithDatabase(DATABASES[index])).thenCompose(Connection::release);
                TestUtil.await(task);
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (ExecutionException e) {
                errors.add(e.getCause());
            }
        }
        MatcherAssert.assertThat((Object)errors.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    private ConnectionPool newConnectionPool() {
        DevNullMetricsListener metrics = DevNullMetricsListener.INSTANCE;
        PoolSettings poolSettings = new PoolSettings(10, 5000L, -1L, -1L);
        Bootstrap bootstrap = BootstrapFactory.newBootstrap((int)1);
        NettyChannelTracker channelTracker = new NettyChannelTracker((MetricsListener)metrics, (EventExecutor)bootstrap.config().group().next(), this.logging);
        NettyChannelHealthChecker channelHealthChecker = new NettyChannelHealthChecker(poolSettings, this.clock, this.logging);
        return new TestConnectionPool(bootstrap, channelTracker, channelHealthChecker, poolSettings, (MetricsListener)metrics, this.logging, this.clock, true);
    }

    private RoutingTableRegistryImpl newRoutingTables(ConnectionPool connectionPool, Rediscovery rediscovery) {
        return new RoutingTableRegistryImpl(connectionPool, rediscovery, this.clock, this.logging, RoutingSettings.STALE_ROUTING_TABLE_PURGE_DELAY_MS);
    }

    private LoadBalancer newLoadBalancer(ConnectionPool connectionPool, RoutingTableRegistry routingTables) {
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(Rediscovery.class);
        return new LoadBalancer(connectionPool, routingTables, rediscovery, (LoadBalancingStrategy)new LeastConnectedLoadBalancingStrategy(connectionPool, this.logging), (EventExecutorGroup)GlobalEventExecutor.INSTANCE, this.logging);
    }

    private CompletableFuture<ClusterCompositionLookupResult> clusterComposition(BoltServerAddress ... addresses) {
        return this.clusterComposition(Duration.ofSeconds(30L).toMillis(), addresses);
    }

    private CompletableFuture<ClusterCompositionLookupResult> expiredClusterComposition(BoltServerAddress ... addresses) {
        return this.clusterComposition(-RoutingSettings.STALE_ROUTING_TABLE_PURGE_DELAY_MS - 1L, addresses);
    }

    private CompletableFuture<ClusterCompositionLookupResult> clusterComposition(long expireAfterMs, BoltServerAddress ... addresses) {
        HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>(Arrays.asList(addresses));
        ClusterComposition composition = new ClusterComposition(this.clock.millis() + expireAfterMs, servers, servers, servers, null);
        return CompletableFuture.completedFuture(new ClusterCompositionLookupResult(composition));
    }

    private class RandomizedRediscovery
    implements Rediscovery {
        private RandomizedRediscovery() {
        }

        public CompletionStage<ClusterCompositionLookupResult> lookupClusterComposition(RoutingTable routingTable, ConnectionPool connectionPool, Bookmark bookmark, String impersonatedUser) {
            HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>();
            for (int i = 0; i < 3; ++i) {
                int index = RoutingTableAndConnectionPoolTest.this.random.nextInt(SERVERS.size());
                BoltServerAddress server = (BoltServerAddress)SERVERS.get(index);
                if (server == null) continue;
                servers.add(server);
            }
            if (servers.size() == 0) {
                BoltServerAddress address = SERVERS.stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeException("No non null server addresses are available"));
                servers.add(address);
            }
            ClusterComposition composition = new ClusterComposition(RoutingTableAndConnectionPoolTest.this.clock.millis() + 1L, servers, servers, servers, null);
            return CompletableFuture.completedFuture(new ClusterCompositionLookupResult(composition));
        }

        public List<BoltServerAddress> resolve() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

