/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.summary.QueryType;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.util.TestUtil;

public abstract class PullAllResponseHandlerTestBase<T extends PullAllResponseHandler> {
    @Test
    void shouldReturnNoFailureWhenAlreadySucceeded() {
        T handler = this.newHandler();
        handler.onSuccess(Collections.emptyMap());
        Throwable failure = (Throwable)TestUtil.await(handler.pullAllFailureAsync());
        Assertions.assertNull((Object)failure);
    }

    @Test
    void shouldReturnNoFailureWhenSucceededAfterFailureRequested() {
        T handler = this.newHandler();
        CompletableFuture failureFuture = handler.pullAllFailureAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)failureFuture.isDone());
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)failureFuture.isDone());
        Assertions.assertNull(TestUtil.await(failureFuture));
    }

    @Test
    void shouldReturnFailureWhenAlreadyFailed() {
        T handler = this.newHandler();
        RuntimeException failure = new RuntimeException("Ops");
        handler.onFailure((Throwable)failure);
        Throwable receivedFailure = (Throwable)TestUtil.await(handler.pullAllFailureAsync());
        Assertions.assertEquals((Object)failure, (Object)receivedFailure);
    }

    @Test
    void shouldReturnFailureWhenFailedAfterFailureRequested() {
        T handler = this.newHandler();
        CompletableFuture failureFuture = handler.pullAllFailureAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)failureFuture.isDone());
        IOException failure = new IOException("Broken pipe");
        handler.onFailure((Throwable)failure);
        Assertions.assertTrue((boolean)failureFuture.isDone());
        Assertions.assertEquals((Object)failure, TestUtil.await(failureFuture));
    }

    @Test
    void shouldReturnFailureWhenRequestedMultipleTimes() {
        T handler = this.newHandler();
        CompletableFuture failureFuture1 = handler.pullAllFailureAsync().toCompletableFuture();
        CompletableFuture failureFuture2 = handler.pullAllFailureAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)failureFuture1.isDone());
        Assertions.assertFalse((boolean)failureFuture2.isDone());
        RuntimeException failure = new RuntimeException("Unable to contact database");
        handler.onFailure((Throwable)failure);
        Assertions.assertTrue((boolean)failureFuture1.isDone());
        Assertions.assertTrue((boolean)failureFuture2.isDone());
        Assertions.assertEquals((Object)failure, TestUtil.await(failureFuture1));
        Assertions.assertEquals((Object)failure, TestUtil.await(failureFuture2));
    }

    @Test
    void shouldReturnFailureOnlyOnceWhenFailedBeforeFailureRequested() {
        T handler = this.newHandler();
        ServiceUnavailableException failure = new ServiceUnavailableException("Connection terminated");
        handler.onFailure((Throwable)failure);
        Assertions.assertEquals((Object)((Object)failure), TestUtil.await(handler.pullAllFailureAsync()));
        Assertions.assertNull(TestUtil.await(handler.pullAllFailureAsync()));
    }

    @Test
    void shouldReturnFailureOnlyOnceWhenFailedAfterFailureRequested() {
        T handler = this.newHandler();
        CompletionStage failureFuture = handler.pullAllFailureAsync();
        SessionExpiredException failure = new SessionExpiredException("Network unreachable");
        handler.onFailure((Throwable)failure);
        Assertions.assertEquals((Object)failure, TestUtil.await(failureFuture));
        Assertions.assertNull(TestUtil.await(handler.pullAllFailureAsync()));
    }

    @Test
    void shouldReturnSummaryWhenAlreadyFailedAndFailureConsumed() {
        Query query = new Query("CREATE ()");
        T handler = this.newHandler(query);
        ServiceUnavailableException failure = new ServiceUnavailableException("Neo4j unreachable");
        handler.onFailure((Throwable)failure);
        Assertions.assertEquals((Object)((Object)failure), TestUtil.await(handler.pullAllFailureAsync()));
        ResultSummary summary = (ResultSummary)TestUtil.await(handler.consumeAsync());
        Assertions.assertNotNull((Object)summary);
        Assertions.assertEquals((Object)query, (Object)summary.query());
    }

    @Test
    void shouldReturnSummaryWhenAlreadySucceeded() {
        Query query = new Query("CREATE () RETURN 42");
        T handler = this.newHandler(query);
        handler.onSuccess(Collections.singletonMap("type", Values.value((String)"rw")));
        ResultSummary summary = (ResultSummary)TestUtil.await(handler.consumeAsync());
        Assertions.assertEquals((Object)query, (Object)summary.query());
        Assertions.assertEquals((Object)QueryType.READ_WRITE, (Object)summary.queryType());
    }

    @Test
    void shouldReturnSummaryWhenSucceededAfterSummaryRequested() {
        Query query = new Query("RETURN 'Hi!");
        T handler = this.newHandler(query);
        CompletableFuture summaryFuture = handler.consumeAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)summaryFuture.isDone());
        handler.onSuccess(Collections.singletonMap("type", Values.value((String)"r")));
        Assertions.assertTrue((boolean)summaryFuture.isDone());
        ResultSummary summary = (ResultSummary)TestUtil.await(summaryFuture);
        Assertions.assertEquals((Object)query, (Object)summary.query());
        Assertions.assertEquals((Object)QueryType.READ_ONLY, (Object)summary.queryType());
    }

    @Test
    void shouldReturnFailureWhenSummaryRequestedWhenAlreadyFailed() {
        Object handler = this.newHandler();
        RuntimeException failure = new RuntimeException("Computer is burning");
        handler.onFailure((Throwable)failure);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(handler.consumeAsync()));
        Assertions.assertEquals((Object)failure, (Object)e);
    }

    @Test
    void shouldReturnFailureWhenFailedAfterSummaryRequested() {
        T handler = this.newHandler();
        CompletableFuture summaryFuture = handler.consumeAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)summaryFuture.isDone());
        IOException failure = new IOException("FAILED to write");
        handler.onFailure((Throwable)failure);
        Assertions.assertTrue((boolean)summaryFuture.isDone());
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(summaryFuture));
        Assertions.assertEquals((Object)failure, (Object)e);
    }

    @Test
    void shouldFailSummaryWhenRequestedMultipleTimes() {
        T handler = this.newHandler();
        CompletableFuture summaryFuture1 = handler.consumeAsync().toCompletableFuture();
        CompletableFuture summaryFuture2 = handler.consumeAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)summaryFuture1.isDone());
        Assertions.assertFalse((boolean)summaryFuture2.isDone());
        ClosedChannelException failure = new ClosedChannelException();
        handler.onFailure((Throwable)failure);
        Assertions.assertTrue((boolean)summaryFuture1.isDone());
        Assertions.assertTrue((boolean)summaryFuture2.isDone());
        Exception e1 = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(summaryFuture2));
        Assertions.assertEquals((Object)failure, (Object)e1);
        Exception e2 = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(summaryFuture1));
        Assertions.assertEquals((Object)failure, (Object)e2);
    }

    @Test
    void shouldPropagateFailureOnlyOnceFromSummary() {
        Query query = new Query("CREATE INDEX ON :Person(name)");
        Object handler = this.newHandler(query);
        IllegalStateException failure = new IllegalStateException("Some state is illegal :(");
        handler.onFailure((Throwable)failure);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(handler.consumeAsync()));
        Assertions.assertEquals((Object)failure, (Object)e);
        ResultSummary summary = (ResultSummary)TestUtil.await(handler.consumeAsync());
        Assertions.assertNotNull((Object)summary);
        Assertions.assertEquals((Object)query, (Object)summary.query());
    }

    @Test
    void shouldPeekSingleAvailableRecord() {
        List<String> keys = Arrays.asList("key1", "key2");
        T handler = this.newHandler(keys);
        handler.onRecord(Values.values((Object[])new Object[]{"a", "b"}));
        Record record = (Record)TestUtil.await(handler.peekAsync());
        Assertions.assertEquals(keys, (Object)record.keys());
        Assertions.assertEquals((Object)"a", (Object)record.get("key1").asString());
        Assertions.assertEquals((Object)"b", (Object)record.get("key2").asString());
    }

    @Test
    void shouldPeekFirstRecordWhenMultipleAvailable() {
        List<String> keys = Arrays.asList("key1", "key2", "key3");
        T handler = this.newHandler(keys);
        handler.onRecord(Values.values((Object[])new Object[]{"a1", "b1", "c1"}));
        handler.onRecord(Values.values((Object[])new Object[]{"a2", "b2", "c2"}));
        handler.onRecord(Values.values((Object[])new Object[]{"a3", "b3", "c3"}));
        Record record = (Record)TestUtil.await(handler.peekAsync());
        Assertions.assertEquals(keys, (Object)record.keys());
        Assertions.assertEquals((Object)"a1", (Object)record.get("key1").asString());
        Assertions.assertEquals((Object)"b1", (Object)record.get("key2").asString());
        Assertions.assertEquals((Object)"c1", (Object)record.get("key3").asString());
    }

    @Test
    void shouldPeekRecordThatBecomesAvailableLater() {
        List<String> keys = Arrays.asList("key1", "key2");
        T handler = this.newHandler(keys);
        CompletableFuture recordFuture = handler.peekAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)recordFuture.isDone());
        handler.onRecord(Values.values((Object[])new Object[]{24, 42}));
        Assertions.assertTrue((boolean)recordFuture.isDone());
        Record record = (Record)TestUtil.await(recordFuture);
        Assertions.assertEquals(keys, (Object)record.keys());
        Assertions.assertEquals((int)24, (int)record.get("key1").asInt());
        Assertions.assertEquals((int)42, (int)record.get("key2").asInt());
    }

    @Test
    void shouldPeekAvailableNothingAfterSuccess() {
        List<String> keys = Arrays.asList("key1", "key2", "key3");
        T handler = this.newHandler(keys);
        handler.onRecord(Values.values((Object[])new Object[]{1, 2, 3}));
        handler.onSuccess(Collections.emptyMap());
        Record record = (Record)TestUtil.await(handler.peekAsync());
        Assertions.assertEquals(keys, (Object)record.keys());
        Assertions.assertEquals((int)1, (int)record.get("key1").asInt());
        Assertions.assertEquals((int)2, (int)record.get("key2").asInt());
        Assertions.assertEquals((int)3, (int)record.get("key3").asInt());
    }

    @Test
    void shouldPeekNothingAfterSuccess() {
        T handler = this.newHandler();
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertNull(TestUtil.await(handler.peekAsync()));
    }

    @Test
    void shouldPeekWhenRequestedMultipleTimes() {
        List<String> keys = Arrays.asList("key1", "key2");
        T handler = this.newHandler(keys);
        CompletableFuture recordFuture1 = handler.peekAsync().toCompletableFuture();
        CompletableFuture recordFuture2 = handler.peekAsync().toCompletableFuture();
        CompletableFuture recordFuture3 = handler.peekAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)recordFuture1.isDone());
        Assertions.assertFalse((boolean)recordFuture2.isDone());
        Assertions.assertFalse((boolean)recordFuture3.isDone());
        handler.onRecord(Values.values((Object[])new Object[]{2, 1}));
        Assertions.assertTrue((boolean)recordFuture1.isDone());
        Assertions.assertTrue((boolean)recordFuture2.isDone());
        Assertions.assertTrue((boolean)recordFuture3.isDone());
        Record record1 = (Record)TestUtil.await(recordFuture1);
        Record record2 = (Record)TestUtil.await(recordFuture2);
        Record record3 = (Record)TestUtil.await(recordFuture3);
        Assertions.assertEquals(keys, (Object)record1.keys());
        Assertions.assertEquals(keys, (Object)record2.keys());
        Assertions.assertEquals(keys, (Object)record3.keys());
        Assertions.assertEquals((int)2, (int)record1.get("key1").asInt());
        Assertions.assertEquals((int)1, (int)record1.get("key2").asInt());
        Assertions.assertEquals((int)2, (int)record2.get("key1").asInt());
        Assertions.assertEquals((int)1, (int)record2.get("key2").asInt());
        Assertions.assertEquals((int)2, (int)record3.get("key1").asInt());
        Assertions.assertEquals((int)1, (int)record3.get("key2").asInt());
    }

    @Test
    void shouldPropagateNotConsumedFailureInPeek() {
        Object handler = this.newHandler();
        RuntimeException failure = new RuntimeException("Something is wrong");
        handler.onFailure((Throwable)failure);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(handler.peekAsync()));
        Assertions.assertEquals((Object)failure, (Object)e);
    }

    @Test
    void shouldPropagateFailureInPeekWhenItBecomesAvailable() {
        T handler = this.newHandler();
        CompletableFuture recordFuture = handler.peekAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)recordFuture.isDone());
        RuntimeException failure = new RuntimeException("Error");
        handler.onFailure((Throwable)failure);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(recordFuture));
        Assertions.assertEquals((Object)failure, (Object)e);
    }

    @Test
    void shouldPropagateFailureInPeekOnlyOnce() {
        Object handler = this.newHandler();
        RuntimeException failure = new RuntimeException("Something is wrong");
        handler.onFailure((Throwable)failure);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(handler.peekAsync()));
        Assertions.assertEquals((Object)failure, (Object)e);
        Assertions.assertNull(TestUtil.await(handler.peekAsync()));
    }

    @Test
    void shouldReturnSingleAvailableRecordInNextAsync() {
        List<String> keys = Arrays.asList("key1", "key2");
        T handler = this.newHandler(keys);
        handler.onRecord(Values.values((Object[])new Object[]{"1", "2"}));
        Record record = (Record)TestUtil.await(handler.nextAsync());
        Assertions.assertNotNull((Object)record);
        Assertions.assertEquals(keys, (Object)record.keys());
        Assertions.assertEquals((Object)"1", (Object)record.get("key1").asString());
        Assertions.assertEquals((Object)"2", (Object)record.get("key2").asString());
    }

    @Test
    void shouldReturnNoRecordsWhenNoneAvailableInNextAsync() {
        T handler = this.newHandler(Arrays.asList("key1", "key2"));
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertNull(TestUtil.await(handler.nextAsync()));
    }

    @Test
    void shouldReturnNoRecordsWhenSuccessComesAfterNextAsync() {
        T handler = this.newHandler(Arrays.asList("key1", "key2"));
        CompletableFuture recordFuture = handler.nextAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)recordFuture.isDone());
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)recordFuture.isDone());
        Assertions.assertNull(TestUtil.await(recordFuture));
    }

    @Test
    void shouldPullAllAvailableRecordsWithNextAsync() {
        List<String> keys = Arrays.asList("key1", "key2", "key3");
        T handler = this.newHandler(keys);
        handler.onRecord(Values.values((Object[])new Object[]{1, 2, 3}));
        handler.onRecord(Values.values((Object[])new Object[]{11, 22, 33}));
        handler.onRecord(Values.values((Object[])new Object[]{111, 222, 333}));
        handler.onRecord(Values.values((Object[])new Object[]{1111, 2222, 3333}));
        handler.onSuccess(Collections.emptyMap());
        Record record1 = (Record)TestUtil.await(handler.nextAsync());
        Assertions.assertNotNull((Object)record1);
        Assertions.assertEquals(keys, (Object)record1.keys());
        Assertions.assertEquals((int)1, (int)record1.get("key1").asInt());
        Assertions.assertEquals((int)2, (int)record1.get("key2").asInt());
        Assertions.assertEquals((int)3, (int)record1.get("key3").asInt());
        Record record2 = (Record)TestUtil.await(handler.nextAsync());
        Assertions.assertNotNull((Object)record2);
        Assertions.assertEquals(keys, (Object)record2.keys());
        Assertions.assertEquals((int)11, (int)record2.get("key1").asInt());
        Assertions.assertEquals((int)22, (int)record2.get("key2").asInt());
        Assertions.assertEquals((int)33, (int)record2.get("key3").asInt());
        Record record3 = (Record)TestUtil.await(handler.nextAsync());
        Assertions.assertNotNull((Object)record3);
        Assertions.assertEquals(keys, (Object)record3.keys());
        Assertions.assertEquals((int)111, (int)record3.get("key1").asInt());
        Assertions.assertEquals((int)222, (int)record3.get("key2").asInt());
        Assertions.assertEquals((int)333, (int)record3.get("key3").asInt());
        Record record4 = (Record)TestUtil.await(handler.nextAsync());
        Assertions.assertNotNull((Object)record4);
        Assertions.assertEquals(keys, (Object)record4.keys());
        Assertions.assertEquals((int)1111, (int)record4.get("key1").asInt());
        Assertions.assertEquals((int)2222, (int)record4.get("key2").asInt());
        Assertions.assertEquals((int)3333, (int)record4.get("key3").asInt());
        Assertions.assertNull(TestUtil.await(handler.nextAsync()));
        Assertions.assertNull(TestUtil.await(handler.nextAsync()));
    }

    @Test
    void shouldReturnRecordInNextAsyncWhenItBecomesAvailableLater() {
        List<String> keys = Arrays.asList("key1", "key2");
        T handler = this.newHandler(keys);
        CompletableFuture recordFuture = handler.nextAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)recordFuture.isDone());
        handler.onRecord(Values.values((Object[])new Object[]{24, 42}));
        Assertions.assertTrue((boolean)recordFuture.isDone());
        Record record = (Record)TestUtil.await(recordFuture);
        Assertions.assertNotNull((Object)record);
        Assertions.assertEquals(keys, (Object)record.keys());
        Assertions.assertEquals((int)24, (int)record.get("key1").asInt());
        Assertions.assertEquals((int)42, (int)record.get("key2").asInt());
    }

    @Test
    void shouldReturnSameRecordOnceWhenRequestedMultipleTimesInNextAsync() {
        List<String> keys = Arrays.asList("key1", "key2");
        T handler = this.newHandler(keys);
        CompletableFuture recordFuture1 = handler.nextAsync().toCompletableFuture();
        CompletableFuture recordFuture2 = handler.nextAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)recordFuture1.isDone());
        Assertions.assertFalse((boolean)recordFuture2.isDone());
        handler.onRecord(Values.values((Object[])new Object[]{"A", "B"}));
        Assertions.assertTrue((boolean)recordFuture1.isDone());
        Assertions.assertTrue((boolean)recordFuture2.isDone());
        Record record1 = (Record)TestUtil.await(recordFuture1);
        Record record2 = (Record)TestUtil.await(recordFuture2);
        Assertions.assertTrue((record1 != null || record2 != null ? 1 : 0) != 0);
        Record record = record1 != null ? record1 : record2;
        Assertions.assertNotNull((Object)record);
        Assertions.assertEquals(keys, (Object)record.keys());
        Assertions.assertEquals((Object)"A", (Object)record.get("key1").asString());
        Assertions.assertEquals((Object)"B", (Object)record.get("key2").asString());
    }

    @Test
    void shouldPropagateExistingFailureInNextAsync() {
        Object handler = this.newHandler();
        RuntimeException error = new RuntimeException("FAILED to read");
        handler.onFailure((Throwable)error);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(handler.nextAsync()));
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldPropagateFailureInNextAsyncWhenFailureMessagesArrivesLater() {
        T handler = this.newHandler();
        CompletableFuture recordFuture = handler.nextAsync().toCompletableFuture();
        Assertions.assertFalse((boolean)recordFuture.isDone());
        RuntimeException error = new RuntimeException("Network failed");
        handler.onFailure((Throwable)error);
        Assertions.assertTrue((boolean)recordFuture.isDone());
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(recordFuture));
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldPropagateFailureFromListAsync() {
        Object handler = this.newHandler();
        RuntimeException error = new RuntimeException("Hi!");
        handler.onFailure((Throwable)error);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(handler.listAsync(Function.identity())));
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldPropagateFailureAfterRecordFromListAsync() {
        Object handler = this.newHandler(Arrays.asList("key1", "key2"));
        handler.onRecord(Values.values((Object[])new Object[]{"a", "b"}));
        RuntimeException error = new RuntimeException("Hi!");
        handler.onFailure((Throwable)error);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(handler.listAsync(Function.identity())));
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldFailListAsyncWhenTransformationFunctionThrows() {
        T handler = this.newHandler(Arrays.asList("key1", "key2"));
        handler.onRecord(Values.values((Object[])new Object[]{1, 2}));
        handler.onRecord(Values.values((Object[])new Object[]{3, 4}));
        handler.onSuccess(Collections.emptyMap());
        RuntimeException error = new RuntimeException("Hi!");
        CompletionStage stage = handler.listAsync(record -> {
            if (record.get(1).asInt() == 4) {
                throw error;
            }
            return 42;
        });
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(stage));
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldReturnEmptyListInListAsyncAfterSuccess() {
        T handler = this.newHandler();
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertEquals(Collections.emptyList(), TestUtil.await(handler.listAsync(Function.identity())));
    }

    @Test
    void shouldReturnTransformedListInListAsync() {
        T handler = this.newHandler(Collections.singletonList("key1"));
        handler.onRecord(Values.values((Object[])new Object[]{1}));
        handler.onRecord(Values.values((Object[])new Object[]{2}));
        handler.onRecord(Values.values((Object[])new Object[]{3}));
        handler.onRecord(Values.values((Object[])new Object[]{4}));
        handler.onSuccess(Collections.emptyMap());
        List transformedList = (List)TestUtil.await(handler.listAsync(record -> record.get(0).asInt() * 2));
        Assertions.assertEquals(Arrays.asList(2, 4, 6, 8), (Object)transformedList);
    }

    @Test
    void shouldReturnNotTransformedListInListAsync() {
        List<String> keys = Arrays.asList("key1", "key2");
        T handler = this.newHandler(keys);
        Value[] fields1 = Values.values((Object[])new Object[]{"a", "b"});
        Value[] fields2 = Values.values((Object[])new Object[]{"c", "d"});
        Value[] fields3 = Values.values((Object[])new Object[]{"e", "f"});
        handler.onRecord(fields1);
        handler.onRecord(fields2);
        handler.onRecord(fields3);
        handler.onSuccess(Collections.emptyMap());
        List list = (List)TestUtil.await(handler.listAsync(Function.identity()));
        List<InternalRecord> expectedRecords = Arrays.asList(new InternalRecord(keys, fields1), new InternalRecord(keys, fields2), new InternalRecord(keys, fields3));
        Assertions.assertEquals(expectedRecords, (Object)list);
    }

    protected T newHandler() {
        return this.newHandler(new Query("RETURN 1"));
    }

    protected T newHandler(Query query) {
        return this.newHandler(query, Collections.emptyList());
    }

    protected T newHandler(List<String> queryKeys) {
        return this.newHandler(new Query("RETURN 1"), queryKeys, this.connectionMock());
    }

    protected T newHandler(Query query, List<String> queryKeys) {
        return this.newHandler(query, queryKeys, this.connectionMock());
    }

    protected T newHandler(List<String> queryKeys, Connection connection) {
        return this.newHandler(new Query("RETURN 1"), queryKeys, connection);
    }

    protected abstract T newHandler(Query var1, List<String> var2, Connection var3);

    protected Connection connectionMock() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.serverAddress()).thenReturn((Object)BoltServerAddress.LOCAL_DEFAULT);
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)TestUtil.anyServerVersion());
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocolV43.INSTANCE);
        Mockito.when((Object)connection.serverAgent()).thenReturn((Object)"Neo4j/4.2.5");
        return connection;
    }
}

