/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;

class ChannelActivityLoggerTest {
    ChannelActivityLoggerTest() {
    }

    @Test
    void shouldReformatWhenChannelIsNull() {
        ChannelActivityLogger activityLogger = new ChannelActivityLogger(null, Logging.none(), this.getClass());
        String reformatted = activityLogger.reformat("Hello!");
        Assertions.assertEquals((Object)"Hello!", (Object)reformatted);
    }

    @Test
    void shouldReformatWithChannelId() {
        EmbeddedChannel channel = new EmbeddedChannel();
        ChannelActivityLogger activityLogger = new ChannelActivityLogger((Channel)channel, Logging.none(), this.getClass());
        String reformatted = activityLogger.reformat("Hello!");
        Assertions.assertEquals((Object)("[0x" + channel.id() + "][][] Hello!"), (Object)reformatted);
    }

    @Test
    void shouldReformatWithChannelIdAndServerAddress() {
        EmbeddedChannel channel = new EmbeddedChannel();
        ChannelAttributes.setServerAddress((Channel)channel, (BoltServerAddress)new BoltServerAddress("somewhere", 1234));
        ChannelActivityLogger activityLogger = new ChannelActivityLogger((Channel)channel, Logging.none(), this.getClass());
        String reformatted = activityLogger.reformat("Hello!");
        Assertions.assertEquals((Object)("[0x" + channel.id() + "][somewhere:1234][] Hello!"), (Object)reformatted);
    }

    @Test
    void shouldReformatWithChannelIdAndConnectionId() {
        EmbeddedChannel channel = new EmbeddedChannel();
        ChannelAttributes.setConnectionId((Channel)channel, (String)"bolt-12345");
        ChannelActivityLogger activityLogger = new ChannelActivityLogger((Channel)channel, Logging.none(), this.getClass());
        String reformatted = activityLogger.reformat("Hello!");
        Assertions.assertEquals((Object)("[0x" + channel.id() + "][][bolt-12345] Hello!"), (Object)reformatted);
    }
}

