/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.logging.Level;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Logger;
import org.neo4j.driver.internal.logging.ConsoleLogging;

class ConsoleLoggingTest {
    private static ByteArrayOutputStream out = new ByteArrayOutputStream();
    private static PrintStream sysErr;

    ConsoleLoggingTest() {
    }

    @BeforeAll
    static void saveSysOut() {
        sysErr = System.err;
        System.setErr(new PrintStream(out));
    }

    @AfterAll
    static void restoreSysOut() {
        System.setErr(sysErr);
    }

    @BeforeEach
    void setup() {
        out.reset();
    }

    @Test
    void shouldOnlyRecordMessageOnce() {
        ConsoleLogging logging = new ConsoleLogging(Level.ALL);
        Logger catLogger = logging.getLog("Cat");
        Logger dogLogger = logging.getLog("Dog");
        catLogger.debug("Meow", new Object[0]);
        dogLogger.debug("Wow", new Object[0]);
        Scanner scanner = new Scanner(new ByteArrayInputStream(out.toByteArray()));
        Assertions.assertTrue((boolean)scanner.hasNextLine());
        Assertions.assertTrue((boolean)scanner.nextLine().contains("Meow"));
        Assertions.assertTrue((boolean)scanner.hasNextLine());
        Assertions.assertTrue((boolean)scanner.nextLine().contains("Wow"));
        Assertions.assertFalse((boolean)scanner.hasNextLine());
    }

    @Test
    void shouldResetLoggerLevel() {
        String logName = ConsoleLogging.class.getName();
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(logName);
        new ConsoleLogging.ConsoleLogger(logName, Level.ALL).debug("Meow", new Object[0]);
        Assertions.assertEquals((Object)Level.ALL, (Object)logger.getLevel());
        new ConsoleLogging.ConsoleLogger(logName, Level.SEVERE).debug("Wow", new Object[0]);
        Assertions.assertEquals((Object)Level.SEVERE, (Object)logger.getLevel());
        Scanner scanner = new Scanner(new ByteArrayInputStream(out.toByteArray()));
        Assertions.assertTrue((boolean)scanner.hasNextLine());
        Assertions.assertTrue((boolean)scanner.nextLine().contains("Meow"));
        Assertions.assertFalse((boolean)scanner.hasNextLine());
    }
}

