/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.logging.Slf4jLogger;
import org.slf4j.Logger;

class Slf4jLoggerTest {
    private final Logger logger = (Logger)Mockito.mock(Logger.class);
    private final Slf4jLogger slf4jLogger = new Slf4jLogger(this.logger);

    Slf4jLoggerTest() {
    }

    @Test
    void shouldLogErrorWithMessageAndThrowable() {
        Mockito.when((Object)this.logger.isErrorEnabled()).thenReturn((Object)true);
        String message = "Hello";
        IllegalArgumentException error = new IllegalArgumentException("World");
        this.slf4jLogger.error(message, (Throwable)error);
        ((Logger)Mockito.verify((Object)this.logger)).error(message, (Throwable)error);
    }

    @Test
    void shouldLogInfoWithMessageAndParams() {
        Mockito.when((Object)this.logger.isInfoEnabled()).thenReturn((Object)true);
        String message = "One %s, two %s, three %s";
        Object[] params = new Object[]{"111", "222", "333"};
        this.slf4jLogger.info(message, params);
        ((Logger)Mockito.verify((Object)this.logger)).info("One 111, two 222, three 333");
    }

    @Test
    void shouldLogWarnWithMessageAndParams() {
        Mockito.when((Object)this.logger.isWarnEnabled()).thenReturn((Object)true);
        String message = "C for %s, d for %s";
        Object[] params = new Object[]{"cat", "dog"};
        this.slf4jLogger.warn(message, params);
        ((Logger)Mockito.verify((Object)this.logger)).warn("C for cat, d for dog");
    }

    @Test
    void shouldLogWarnWithMessageAndThrowable() {
        Mockito.when((Object)this.logger.isWarnEnabled()).thenReturn((Object)true);
        String message = "Hello";
        RuntimeException error = new RuntimeException("World");
        this.slf4jLogger.warn(message, (Throwable)error);
        ((Logger)Mockito.verify((Object)this.logger)).warn(message, (Throwable)error);
    }

    @Test
    void shouldLogDebugWithMessageAndParams() {
        Mockito.when((Object)this.logger.isDebugEnabled()).thenReturn((Object)true);
        String message = "Hello%s%s!";
        Object[] params = new Object[]{" ", "World"};
        this.slf4jLogger.debug(message, params);
        ((Logger)Mockito.verify((Object)this.logger)).debug("Hello World!");
    }

    @Test
    void shouldLogTraceWithMessageAndParams() {
        Mockito.when((Object)this.logger.isTraceEnabled()).thenReturn((Object)true);
        String message = "I'll be %s!";
        Object[] params = new Object[]{"back"};
        this.slf4jLogger.trace(message, params);
        ((Logger)Mockito.verify((Object)this.logger)).trace("I'll be back!");
    }

    @Test
    void shouldCheckIfDebugIsEnabled() {
        Mockito.when((Object)this.logger.isDebugEnabled()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.slf4jLogger.isDebugEnabled());
        Mockito.when((Object)this.logger.isDebugEnabled()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.slf4jLogger.isDebugEnabled());
    }

    @Test
    void shouldCheckIfTraceIsEnabled() {
        Mockito.when((Object)this.logger.isTraceEnabled()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.slf4jLogger.isTraceEnabled());
        Mockito.when((Object)this.logger.isTraceEnabled()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.slf4jLogger.isTraceEnabled());
    }
}

