/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.BeginMessageEncoder;
import org.neo4j.driver.internal.messaging.request.BeginMessage;
import org.neo4j.driver.internal.messaging.request.ResetMessage;

class BeginMessageEncoderTest {
    private final BeginMessageEncoder encoder = new BeginMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    BeginMessageEncoderTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    void shouldEncodeBeginMessage(AccessMode mode, String impersonatedUser) throws Exception {
        Bookmark bookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx42");
        HashMap<String, Value> txMetadata = new HashMap<String, Value>();
        txMetadata.put("hello", Values.value((String)"world"));
        txMetadata.put("answer", Values.value((int)42));
        Duration txTimeout = Duration.ofSeconds(1L);
        this.encoder.encode((Message)new BeginMessage(bookmark, txTimeout, txMetadata, mode, DatabaseNameUtil.defaultDatabase(), impersonatedUser), this.packer);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)order.verify((Object)this.packer)).packStructHeader(1, (byte)17);
        HashMap<String, Value> expectedMetadata = new HashMap<String, Value>();
        expectedMetadata.put("bookmarks", Values.value((Object)bookmark.values()));
        expectedMetadata.put("tx_timeout", Values.value((int)1000));
        expectedMetadata.put("tx_metadata", Values.value(txMetadata));
        if (mode == AccessMode.READ) {
            expectedMetadata.put("mode", Values.value((String)"r"));
        }
        if (impersonatedUser != null) {
            expectedMetadata.put("imp_user", Values.value((String)impersonatedUser));
        }
        ((ValuePacker)order.verify((Object)this.packer)).pack(expectedMetadata);
    }

    private static Stream<Arguments> arguments() {
        return Arrays.stream(AccessMode.values()).flatMap(accessMode -> Stream.of(Arguments.of((Object[])new Object[]{accessMode, "user"}), Arguments.of((Object[])new Object[]{accessMode, null})));
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)ResetMessage.RESET, this.packer));
    }
}

