/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.CommitMessageEncoder;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.DiscardAllMessage;

class CommitMessageEncoderTest {
    private final CommitMessageEncoder encoder = new CommitMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    CommitMessageEncoderTest() {
    }

    @Test
    void shouldEncodeCommitMessage() throws Exception {
        this.encoder.encode(CommitMessage.COMMIT, this.packer);
        ((ValuePacker)Mockito.verify((Object)this.packer)).packStructHeader(0, (byte)18);
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)DiscardAllMessage.DISCARD_ALL, this.packer));
    }
}

