/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.DiscardAllMessageEncoder;
import org.neo4j.driver.internal.messaging.request.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;

class DiscardAllMessageEncoderTest {
    private final DiscardAllMessageEncoder encoder = new DiscardAllMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    DiscardAllMessageEncoderTest() {
    }

    @Test
    void shouldEncodeDiscardAllMessage() throws Exception {
        this.encoder.encode((Message)DiscardAllMessage.DISCARD_ALL, this.packer);
        ((ValuePacker)Mockito.verify((Object)this.packer)).packStructHeader(0, (byte)47);
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)new DiscardMessage(100L, 200L), this.packer));
    }
}

