/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.HelloMessageEncoder;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;

class HelloMessageEncoderTest {
    private final HelloMessageEncoder encoder = new HelloMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    HelloMessageEncoderTest() {
    }

    @Test
    void shouldEncodeHelloMessage() throws Exception {
        HashMap<String, Value> authToken = new HashMap<String, Value>();
        authToken.put("username", Values.value((String)"bob"));
        authToken.put("password", Values.value((String)"secret"));
        this.encoder.encode((Message)new HelloMessage("MyDriver", authToken, null, false), this.packer);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)order.verify((Object)this.packer)).packStructHeader(1, (byte)1);
        HashMap<String, Value> expectedMetadata = new HashMap<String, Value>(authToken);
        expectedMetadata.put("user_agent", Values.value((String)"MyDriver"));
        ((ValuePacker)order.verify((Object)this.packer)).pack(expectedMetadata);
    }

    @Test
    void shouldEncodeHelloMessageWithRoutingContext() throws Exception {
        HashMap<String, Value> authToken = new HashMap<String, Value>();
        authToken.put("username", Values.value((String)"bob"));
        authToken.put("password", Values.value((String)"secret"));
        HashMap<String, String> routingContext = new HashMap<String, String>();
        routingContext.put("policy", "eu-fast");
        this.encoder.encode((Message)new HelloMessage("MyDriver", authToken, routingContext, false), this.packer);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)order.verify((Object)this.packer)).packStructHeader(1, (byte)1);
        HashMap<String, Value> expectedMetadata = new HashMap<String, Value>(authToken);
        expectedMetadata.put("user_agent", Values.value((String)"MyDriver"));
        expectedMetadata.put("routing", Values.value(routingContext));
        ((ValuePacker)order.verify((Object)this.packer)).pack(expectedMetadata);
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)PullAllMessage.PULL_ALL, this.packer));
    }
}

