/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.PullAllMessageEncoder;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;

class PullAllMessageEncoderTest {
    private final PullAllMessageEncoder encoder = new PullAllMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    PullAllMessageEncoderTest() {
    }

    @Test
    void shouldEncodePullAllMessage() throws Exception {
        this.encoder.encode((Message)PullAllMessage.PULL_ALL, this.packer);
        ((ValuePacker)Mockito.verify((Object)this.packer)).packStructHeader(0, (byte)63);
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)new PullMessage(100L, 200L), this.packer));
    }
}

