/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.ResetMessageEncoder;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;

class ResetMessageEncoderTest {
    private final ResetMessageEncoder encoder = new ResetMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    ResetMessageEncoderTest() {
    }

    @Test
    void shouldEncodeResetMessage() throws Exception {
        this.encoder.encode((Message)ResetMessage.RESET, this.packer);
        ((ValuePacker)Mockito.verify((Object)this.packer)).packStructHeader(0, (byte)15);
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 2")), this.packer));
    }
}

