/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.RunWithMetadataMessageEncoder;
import org.neo4j.driver.internal.messaging.request.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;

class RunWithMetadataMessageEncoderTest {
    private final RunWithMetadataMessageEncoder encoder = new RunWithMetadataMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    RunWithMetadataMessageEncoderTest() {
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldEncodeRunWithMetadataMessage(AccessMode mode) throws Exception {
        Map<String, Value> params = Collections.singletonMap("answer", Values.value((int)42));
        Bookmark bookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx999");
        HashMap<String, Value> txMetadata = new HashMap<String, Value>();
        txMetadata.put("key1", Values.value((String)"value1"));
        txMetadata.put("key2", Values.value((int[])new int[]{1, 2, 3, 4, 5}));
        txMetadata.put("key3", Values.value((boolean)true));
        Duration txTimeout = Duration.ofMillis(42L);
        Query query = new Query("RETURN $answer", Values.value(params));
        this.encoder.encode((Message)RunWithMetadataMessage.autoCommitTxRunMessage((Query)query, (Duration)txTimeout, txMetadata, (DatabaseName)DatabaseNameUtil.defaultDatabase(), (AccessMode)mode, (Bookmark)bookmark, null), this.packer);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)order.verify((Object)this.packer)).packStructHeader(3, (byte)16);
        ((ValuePacker)order.verify((Object)this.packer)).pack("RETURN $answer");
        ((ValuePacker)order.verify((Object)this.packer)).pack(params);
        HashMap<String, Value> expectedMetadata = new HashMap<String, Value>();
        expectedMetadata.put("bookmarks", Values.value((Object)bookmark.values()));
        expectedMetadata.put("tx_timeout", Values.value((int)42));
        expectedMetadata.put("tx_metadata", Values.value(txMetadata));
        if (mode == AccessMode.READ) {
            expectedMetadata.put("mode", Values.value((String)"r"));
        }
        ((ValuePacker)order.verify((Object)this.packer)).pack(expectedMetadata);
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)DiscardAllMessage.DISCARD_ALL, this.packer));
    }
}

