/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MicrometerConnectionPoolMetrics;
import org.neo4j.driver.internal.metrics.MicrometerTimerListenerEvent;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.net.ServerAddress;

class MicrometerConnectionPoolMetricsTest {
    static final String ID = "id";
    MicrometerConnectionPoolMetrics metrics;
    BoltServerAddress address;
    ConnectionPool pool;
    MeterRegistry registry;
    AtomicInteger inUse = new AtomicInteger(0);
    IntSupplier inUseSupplier = this.inUse::get;
    AtomicInteger idle = new AtomicInteger(0);
    IntSupplier idleSupplier = this.idle::get;

    MicrometerConnectionPoolMetricsTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.address = new BoltServerAddress("host", "127.0.0.1", 7687);
        this.pool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        this.registry = new SimpleMeterRegistry();
        this.metrics = new MicrometerConnectionPoolMetrics(ID, (ServerAddress)this.address, this.inUseSupplier, this.idleSupplier, this.registry);
    }

    @Test
    void shouldIncrementCreatingAndStartTimerOnBeforeCreating() {
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.creating()).willReturn((Object)1);
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        this.metrics.beforeCreating(event);
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
        ((ListenerEvent)BDDMockito.then((Object)event).should()).start();
    }

    @Test
    void shouldIncrementFailedToCreateAndDecrementCreatingOnAfterFailedToCreate() {
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.failedToCreate()).willReturn((Object)1L);
        BDDMockito.given((Object)expectedMetrics.creating()).willReturn((Object)-1);
        this.metrics.afterFailedToCreate();
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
    }

    @Test
    void shouldDecrementCreatingAndIncrementCreatedAndStopTimerOnAfterCreated() {
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.creating()).willReturn((Object)-1);
        BDDMockito.given((Object)expectedMetrics.created()).willReturn((Object)1L);
        Timer timer = this.registry.get("neo4j.driver.connections.creation").timer();
        long timerCount = timer.count();
        MicrometerTimerListenerEvent event = new MicrometerTimerListenerEvent(this.registry);
        event.start();
        this.metrics.afterCreated((ListenerEvent)event);
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
        Assertions.assertEquals((long)(timerCount + 1L), (long)timer.count());
    }

    @Test
    void shouldIncrementClosedOnAfterClosed() {
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.closed()).willReturn((Object)1L);
        this.metrics.afterClosed();
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
    }

    @Test
    void shouldStartTimerAndIncrementAcquiringOnBeforeAcquiringOrCreating() {
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.acquiring()).willReturn((Object)1);
        this.metrics.beforeAcquiringOrCreating(event);
        ((ListenerEvent)BDDMockito.then((Object)event).should()).start();
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
    }

    @Test
    void shouldDecrementAcquiringOnAfterAcquiringOrCreating() {
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.acquiring()).willReturn((Object)-1);
        this.metrics.afterAcquiringOrCreating();
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
    }

    @Test
    void shouldIncrementAcquiredAndStopTimerOnAfterAcquiredOrCreated() {
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.acquired()).willReturn((Object)1L);
        Timer timer = this.registry.get("neo4j.driver.connections.acquisition").timer();
        long timerCount = timer.count();
        MicrometerTimerListenerEvent event = new MicrometerTimerListenerEvent(this.registry);
        event.start();
        this.metrics.afterAcquiredOrCreated((ListenerEvent)event);
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
        Assertions.assertEquals((long)(timerCount + 1L), (long)timer.count());
    }

    @Test
    void shouldIncrementTimedOutToAcquireOnAfterTimedOutToAcquireOrCreate() {
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.timedOutToAcquire()).willReturn((Object)1L);
        this.metrics.afterTimedOutToAcquireOrCreate();
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
    }

    @Test
    void shouldStartTimerOnAcquired() {
        ListenerEvent event = (ListenerEvent)Mockito.mock(ListenerEvent.class);
        this.metrics.acquired(event);
        ((ListenerEvent)BDDMockito.then((Object)event).should()).start();
    }

    @Test
    void shouldIncrementReleasedAndStopTimerOnReleased() {
        ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
        BDDMockito.given((Object)expectedMetrics.totalInUseCount()).willReturn((Object)1L);
        Timer timer = this.registry.get("neo4j.driver.connections.usage").timer();
        long timerCount = timer.count();
        MicrometerTimerListenerEvent event = new MicrometerTimerListenerEvent(this.registry);
        event.start();
        this.metrics.released((ListenerEvent)event);
        this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
        Assertions.assertEquals((long)(timerCount + 1L), (long)timer.count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldUseInUseSupplier() {
        try {
            int expected = 5;
            this.inUse.compareAndSet(0, expected);
            ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
            BDDMockito.given((Object)expectedMetrics.inUse()).willReturn((Object)expected);
            int actual = this.metrics.inUse();
            Assertions.assertEquals((int)expected, (int)actual);
            this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
        }
        finally {
            this.inUse.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldUseIdleSupplier() {
        try {
            int expected = 5;
            this.idle.compareAndSet(0, expected);
            ConnectionPoolMetrics expectedMetrics = (ConnectionPoolMetrics)Mockito.mock(ConnectionPoolMetrics.class);
            BDDMockito.given((Object)expectedMetrics.idle()).willReturn((Object)expected);
            int actual = this.metrics.idle();
            Assertions.assertEquals((int)expected, (int)actual);
            this.verifyMetrics(expectedMetrics, (ConnectionPoolMetrics)this.metrics);
        }
        finally {
            this.idle.set(0);
        }
    }

    void verifyMetrics(ConnectionPoolMetrics expected, ConnectionPoolMetrics actual) {
        Assertions.assertEquals((Object)ID, (Object)actual.id());
        Assertions.assertEquals((int)expected.inUse(), (int)actual.inUse());
        Assertions.assertEquals((double)expected.inUse(), (double)this.registry.get("neo4j.driver.connections.in.use").gauge().value());
        Assertions.assertEquals((int)expected.idle(), (int)actual.idle());
        Assertions.assertEquals((double)expected.idle(), (double)this.registry.get("neo4j.driver.connections.idle").gauge().value());
        Assertions.assertEquals((int)expected.creating(), (int)actual.creating());
        Assertions.assertEquals((double)expected.creating(), (double)this.registry.get("neo4j.driver.connections.creating").gauge().value());
        Assertions.assertEquals((long)expected.created(), (long)actual.created());
        Assertions.assertEquals((long)expected.created(), (long)this.registry.get("neo4j.driver.connections.creation").timer().count());
        Assertions.assertEquals((long)expected.failedToCreate(), (long)actual.failedToCreate());
        Assertions.assertEquals((double)expected.failedToCreate(), (double)this.registry.get("neo4j.driver.connections.failed").counter().count());
        Assertions.assertEquals((long)expected.closed(), (long)actual.closed());
        Assertions.assertEquals((double)expected.closed(), (double)this.registry.get("neo4j.driver.connections.closed").counter().count());
        Assertions.assertEquals((int)expected.acquiring(), (int)actual.acquiring());
        Assertions.assertEquals((double)expected.acquiring(), (double)this.registry.get("neo4j.driver.connections.acquiring").gauge().value());
        Assertions.assertEquals((long)expected.acquired(), (long)actual.acquired());
        Assertions.assertEquals((long)expected.acquired(), (long)this.registry.get("neo4j.driver.connections.acquisition").timer().count());
        Assertions.assertEquals((long)expected.timedOutToAcquire(), (long)actual.timedOutToAcquire());
        Assertions.assertEquals((double)expected.timedOutToAcquire(), (double)this.registry.get("neo4j.driver.connections.acquisition.timeout").counter().count());
        Assertions.assertEquals((long)expected.totalAcquisitionTime(), (long)actual.totalAcquisitionTime());
        Assertions.assertEquals((long)expected.totalAcquisitionTime(), (long)((long)this.registry.get("neo4j.driver.connections.acquisition").timer().totalTime(TimeUnit.MILLISECONDS)));
        Assertions.assertEquals((long)expected.totalConnectionTime(), (long)actual.totalConnectionTime());
        Assertions.assertEquals((long)expected.totalConnectionTime(), (long)((long)this.registry.get("neo4j.driver.connections.creation").timer().totalTime(TimeUnit.MILLISECONDS)));
        Assertions.assertEquals((long)expected.totalInUseTime(), (long)actual.totalInUseTime());
        Assertions.assertEquals((long)expected.totalInUseTime(), (long)((long)this.registry.get("neo4j.driver.connections.usage").timer().totalTime(TimeUnit.MILLISECONDS)));
        Assertions.assertEquals((long)expected.totalInUseCount(), (long)actual.totalInUseCount());
        Assertions.assertEquals((long)expected.totalInUseCount(), (long)this.registry.get("neo4j.driver.connections.usage").timer().count());
    }
}

