/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.reactive.InternalRxResult;
import org.neo4j.driver.internal.reactive.util.ListBasedPullHandler;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

class InternalRxResultTest {
    InternalRxResultTest() {
    }

    @Test
    void shouldInitCursorFuture() {
        RxResultCursor cursor = (RxResultCursor)Mockito.mock(RxResultCursorImpl.class);
        InternalRxResult rxResult = this.newRxResult(cursor);
        CompletableFuture cursorFuture = rxResult.initCursorFuture().toCompletableFuture();
        Assert.assertTrue((boolean)cursorFuture.isDone());
        Assert.assertThat((Object)((RxResultCursor)Futures.getNow(cursorFuture)), (Matcher)CoreMatchers.equalTo((Object)cursor));
    }

    @Test
    void shouldInitCursorFutureWithFailedCursor() {
        RuntimeException error = new RuntimeException("Failed to obtain cursor probably due to connection problem");
        InternalRxResult rxResult = this.newRxResult(error);
        CompletableFuture cursorFuture = rxResult.initCursorFuture().toCompletableFuture();
        Assert.assertTrue((boolean)cursorFuture.isDone());
        RuntimeException actualError = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> Futures.getNow((CompletionStage)cursorFuture));
        Assert.assertThat((Object)actualError.getCause(), (Matcher)CoreMatchers.equalTo((Object)error));
    }

    @Test
    void shouldObtainKeys() {
        RxResultCursor cursor = (RxResultCursor)Mockito.mock(RxResultCursorImpl.class);
        InternalRxResult rxResult = this.newRxResult(cursor);
        List<String> keys = Arrays.asList("one", "two", "three");
        Mockito.when((Object)cursor.keys()).thenReturn(keys);
        StepVerifier.create((Publisher)Flux.from((Publisher)rxResult.keys())).expectNext(Arrays.asList("one", "two", "three")).verifyComplete();
    }

    @Test
    void shouldErrorWhenFailedObtainKeys() {
        RuntimeException error = new RuntimeException("Failed to obtain cursor");
        InternalRxResult rxResult = this.newRxResult(error);
        StepVerifier.create((Publisher)Flux.from((Publisher)rxResult.keys())).expectErrorMatches(Predicate.isEqual(error)).verify();
    }

    @Test
    void shouldCancelKeys() {
        RxResultCursor cursor = (RxResultCursor)Mockito.mock(RxResultCursorImpl.class);
        InternalRxResult rxResult = this.newRxResult(cursor);
        List<String> keys = Arrays.asList("one", "two", "three");
        Mockito.when((Object)cursor.keys()).thenReturn(keys);
        StepVerifier.create((Publisher)Flux.from((Publisher)rxResult.keys()).limitRate(1).take(1L)).expectNext(Arrays.asList("one", "two", "three")).verifyComplete();
    }

    @Test
    void shouldObtainRecordsAndSummary() {
        InternalRecord record1 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{1, 1, 1}));
        InternalRecord record2 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{2, 2, 2}));
        InternalRecord record3 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{3, 3, 3}));
        ListBasedPullHandler pullHandler = new ListBasedPullHandler(Arrays.asList(record1, record2, record3));
        InternalRxResult rxResult = this.newRxResult((PullResponseHandler)pullHandler);
        StepVerifier.create((Publisher)Flux.from((Publisher)rxResult.records())).expectNext((Object)record1).expectNext((Object)record2).expectNext((Object)record3).verifyComplete();
        StepVerifier.create((Publisher)Mono.from((Publisher)rxResult.consume())).expectNextCount(1L).verifyComplete();
    }

    @Test
    void shouldCancelStreamingButObtainSummary() {
        InternalRecord record1 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{1, 1, 1}));
        InternalRecord record2 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{2, 2, 2}));
        InternalRecord record3 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{3, 3, 3}));
        ListBasedPullHandler pullHandler = new ListBasedPullHandler(Arrays.asList(record1, record2, record3));
        InternalRxResult rxResult = this.newRxResult((PullResponseHandler)pullHandler);
        StepVerifier.create((Publisher)Flux.from((Publisher)rxResult.records()).limitRate(1).take(1L)).expectNext((Object)record1).verifyComplete();
        StepVerifier.create((Publisher)Mono.from((Publisher)rxResult.consume())).expectNextCount(1L).verifyComplete();
    }

    @Test
    void shouldErrorIfFailedToCreateCursor() {
        RuntimeException error = new RuntimeException("Hi");
        InternalRxResult rxResult = this.newRxResult(error);
        StepVerifier.create((Publisher)Flux.from((Publisher)rxResult.records())).expectErrorMatches(Predicate.isEqual(error)).verify();
        StepVerifier.create((Publisher)Mono.from((Publisher)rxResult.consume())).expectErrorMatches(Predicate.isEqual(error)).verify();
    }

    @Test
    void shouldErrorIfFailedToStream() {
        RuntimeException error = new RuntimeException("Hi");
        InternalRxResult rxResult = this.newRxResult((PullResponseHandler)new ListBasedPullHandler(error));
        StepVerifier.create((Publisher)Flux.from((Publisher)rxResult.records())).expectErrorMatches(Predicate.isEqual(error)).verify();
        StepVerifier.create((Publisher)Mono.from((Publisher)rxResult.consume())).assertNext(summary -> Assert.assertThat((Object)summary, (Matcher)CoreMatchers.instanceOf(ResultSummary.class))).verifyComplete();
    }

    private InternalRxResult newRxResult(PullResponseHandler pullHandler) {
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        RxResultCursorImpl cursor = new RxResultCursorImpl(runHandler, pullHandler);
        return this.newRxResult((RxResultCursor)cursor);
    }

    private InternalRxResult newRxResult(RxResultCursor cursor) {
        return new InternalRxResult(() -> CompletableFuture.completedFuture(cursor));
    }

    private InternalRxResult newRxResult(Throwable error) {
        return new InternalRxResult(() -> Futures.failedFuture((Throwable)new CompletionException(error)));
    }
}

