/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.summary.InternalNotification;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;

class InternalNotificationTest {
    InternalNotificationTest() {
    }

    @Test
    void shouldHandleNotificationWithPosition() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", new StringValue("A description"));
        map.put("code", new StringValue("Neo.DummyNotification"));
        map.put("title", new StringValue("A title"));
        map.put("severity", new StringValue("WARNING"));
        HashMap<String, IntegerValue> position = new HashMap<String, IntegerValue>();
        position.put("offset", new IntegerValue(0L));
        position.put("column", new IntegerValue(1L));
        position.put("line", new IntegerValue(2L));
        map.put("position", new MapValue(position));
        MapValue value = new MapValue(map);
        Notification notification = (Notification)InternalNotification.VALUE_TO_NOTIFICATION.apply(value);
        MatcherAssert.assertThat((Object)notification.description(), (Matcher)CoreMatchers.equalTo((Object)"A description"));
        MatcherAssert.assertThat((Object)notification.code(), (Matcher)CoreMatchers.equalTo((Object)"Neo.DummyNotification"));
        MatcherAssert.assertThat((Object)notification.title(), (Matcher)CoreMatchers.equalTo((Object)"A title"));
        MatcherAssert.assertThat((Object)notification.severity(), (Matcher)CoreMatchers.equalTo((Object)"WARNING"));
        InputPosition pos = notification.position();
        MatcherAssert.assertThat((Object)pos.offset(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)pos.column(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)pos.line(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    void shouldHandleNotificationWithoutPosition() {
        HashMap<String, StringValue> map = new HashMap<String, StringValue>();
        map.put("description", new StringValue("A description"));
        map.put("code", new StringValue("Neo.DummyNotification"));
        map.put("title", new StringValue("A title"));
        MapValue value = new MapValue(map);
        Notification notification = (Notification)InternalNotification.VALUE_TO_NOTIFICATION.apply(value);
        MatcherAssert.assertThat((Object)notification.description(), (Matcher)CoreMatchers.equalTo((Object)"A description"));
        MatcherAssert.assertThat((Object)notification.code(), (Matcher)CoreMatchers.equalTo((Object)"Neo.DummyNotification"));
        MatcherAssert.assertThat((Object)notification.title(), (Matcher)CoreMatchers.equalTo((Object)"A title"));
        MatcherAssert.assertThat((Object)notification.position(), (Matcher)Matchers.nullValue());
    }
}

