/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mockito.Mockito;

public class ImmediateSchedulingEventExecutor
implements EventExecutor {
    private final EventExecutor delegate;
    private final List<Long> scheduleDelays;

    public ImmediateSchedulingEventExecutor() {
        this((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public ImmediateSchedulingEventExecutor(EventExecutor delegate) {
        this.delegate = delegate;
        this.scheduleDelays = new CopyOnWriteArrayList<Long>();
    }

    public List<Long> scheduleDelays() {
        return Collections.unmodifiableList(this.scheduleDelays);
    }

    public EventExecutor next() {
        return this;
    }

    public EventExecutorGroup parent() {
        return this;
    }

    public boolean inEventLoop() {
        return this.delegate.inEventLoop();
    }

    public boolean inEventLoop(Thread thread) {
        return this.delegate.inEventLoop(thread);
    }

    public <V> Promise<V> newPromise() {
        return this.delegate.newPromise();
    }

    public <V> ProgressivePromise<V> newProgressivePromise() {
        return this.delegate.newProgressivePromise();
    }

    public <V> Future<V> newSucceededFuture(V result) {
        return this.delegate.newSucceededFuture(result);
    }

    public <V> Future<V> newFailedFuture(Throwable cause) {
        return this.delegate.newFailedFuture(cause);
    }

    public boolean isShuttingDown() {
        return this.delegate.isShuttingDown();
    }

    public Future<?> shutdownGracefully() {
        return this.delegate.shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.delegate.shutdownGracefully(quietPeriod, timeout, unit);
    }

    public Future<?> terminationFuture() {
        return this.delegate.terminationFuture();
    }

    @Deprecated
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Deprecated
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    public Iterator<EventExecutor> iterator() {
        return this.delegate.iterator();
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(task, result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(task);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.scheduleDelays.add(unit.toMillis(delay));
        this.delegate.execute(command);
        return (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.scheduleDelays.add(unit.toMillis(delay));
        this.delegate.submit(callable);
        return (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.delegate.execute(command);
    }
}

