/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Queue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.util.Iterables;

class IterablesTest {
    IterablesTest() {
    }

    @Test
    void shouldCreateHashMapWithExpectedSize() {
        Assertions.assertNotNull((Object)Iterables.newHashMapWithSize((int)42));
    }

    @Test
    void shouldCreateLinkedHashMapWithExpectedSize() {
        Assertions.assertNotNull((Object)Iterables.newLinkedHashMapWithSize((int)42));
    }

    @Test
    void shouldThrowWhenNegativeHashMapSizeGiven() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Iterables.newHashMapWithSize((int)-42));
    }

    @Test
    void shouldThrowWhenNegativeLinkedHashMapSizeGiven() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Iterables.newLinkedHashMapWithSize((int)-42));
    }

    @Test
    void shouldReturnEmptyQueue() {
        Queue queue = Iterables.emptyQueue();
        Assertions.assertEquals((int)0, (int)queue.size());
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertNull(queue.peek());
        Assertions.assertNull(queue.poll());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> queue.add("Hello"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> queue.offer("World"));
    }

    @Test
    void shouldReturnSameEmptyQueue() {
        Assertions.assertSame((Object)Iterables.emptyQueue(), (Object)Iterables.emptyQueue());
    }
}

