/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.internal.util.DisabledOnNeo4jWith;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jEdition;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.util.Neo4jRunner;
import org.neo4j.driver.util.Neo4jSettings;

public class Neo4jWithFeatureCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_NOT_ANNOTATED = ConditionEvaluationResult.enabled((String)"Neither @EnabledOnNeo4jWith nor @DisabledOnNeo4jWith is present");
    private static final ConditionEvaluationResult ENABLED_UNKNOWN_DB_VERSION = ConditionEvaluationResult.enabled((String)"Shared neo4j is not running, unable to check version");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional elementOptional = context.getElement();
        if (elementOptional.isPresent()) {
            AnnotatedElement element = (AnnotatedElement)elementOptional.get();
            EnabledOnNeo4jWith enabledAnnotation = element.getAnnotation(EnabledOnNeo4jWith.class);
            if (enabledAnnotation != null) {
                ConditionEvaluationResult result = Neo4jWithFeatureCondition.checkFeatureAvailability(enabledAnnotation.value(), false);
                if (enabledAnnotation.edition() != Neo4jEdition.UNDEFINED) {
                    result = Neo4jWithFeatureCondition.checkEditionAvailability(result, enabledAnnotation.edition());
                }
                return result;
            }
            DisabledOnNeo4jWith disabledAnnotation = element.getAnnotation(DisabledOnNeo4jWith.class);
            if (disabledAnnotation != null) {
                return Neo4jWithFeatureCondition.checkFeatureAvailability(disabledAnnotation.value(), true);
            }
        }
        return ENABLED_NOT_ANNOTATED;
    }

    private static ConditionEvaluationResult checkFeatureAvailability(Neo4jFeature feature, boolean negated) {
        Driver driver = Neo4jWithFeatureCondition.getSharedNeo4jDriver();
        if (driver != null) {
            ServerVersion version = ServerVersion.version((Driver)driver);
            return Neo4jWithFeatureCondition.createResult(version, feature, negated);
        }
        return ENABLED_UNKNOWN_DB_VERSION;
    }

    private static ConditionEvaluationResult checkEditionAvailability(ConditionEvaluationResult previousResult, Neo4jEdition edition) {
        if (previousResult.isDisabled()) {
            return previousResult;
        }
        Driver driver = Neo4jWithFeatureCondition.getSharedNeo4jDriver();
        if (driver != null) {
            try (Session session = driver.session();){
                String value = session.run("CALL dbms.components() YIELD edition").single().get("edition").asString();
                boolean editionMatches = edition.matches(value);
                ConditionEvaluationResult conditionEvaluationResult = editionMatches ? ConditionEvaluationResult.enabled((String)(previousResult.getReason().map(v -> v + " and enabled").orElse("Enabled") + " on " + value + "-edition")) : ConditionEvaluationResult.disabled((String)(previousResult.getReason().map(v -> v + " but disabled").orElse("Disabled") + " on " + value + "-edition"));
                return conditionEvaluationResult;
            }
        }
        return ENABLED_UNKNOWN_DB_VERSION;
    }

    private static ConditionEvaluationResult createResult(ServerVersion version, Neo4jFeature feature, boolean negated) {
        if (feature.availableIn(version)) {
            return negated ? ConditionEvaluationResult.disabled((String)("Disabled on neo4j " + version + " because it supports " + (Object)((Object)feature))) : ConditionEvaluationResult.enabled((String)("Enabled on neo4j " + version + " because it supports " + (Object)((Object)feature)));
        }
        return negated ? ConditionEvaluationResult.enabled((String)("Enabled on neo4j " + version + " because it does not support " + (Object)((Object)feature))) : ConditionEvaluationResult.disabled((String)("Disabled on neo4j " + version + " because it does not support " + (Object)((Object)feature)));
    }

    private static Driver getSharedNeo4jDriver() {
        try {
            Neo4jRunner runner = Neo4jRunner.getOrCreateGlobalRunner();
            runner.ensureRunning(Neo4jSettings.TEST_SETTINGS);
            return runner.driver();
        }
        catch (Throwable t) {
            System.err.println("Failed to check database version in the test execution condition");
            t.printStackTrace();
            return null;
        }
    }
}

