/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.neo4j.driver.internal.packstream.PackOutput;

public class ChannelOutput
implements PackOutput {
    private final WritableByteChannel channel;

    public ChannelOutput(WritableByteChannel channel) {
        this.channel = channel;
    }

    public PackOutput writeBytes(byte[] data) throws IOException {
        this.channel.write(ByteBuffer.wrap(data));
        return this;
    }

    public PackOutput writeByte(byte value) throws IOException {
        this.channel.write(ByteBuffer.wrap(new byte[]{value}));
        return this;
    }

    public PackOutput writeShort(short value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value);
        buffer.flip();
        this.channel.write(buffer);
        return this;
    }

    public PackOutput writeInt(int value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        buffer.flip();
        this.channel.write(buffer);
        return this;
    }

    public PackOutput writeLong(long value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        buffer.flip();
        this.channel.write(buffer);
        return this;
    }

    public PackOutput writeDouble(double value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putDouble(value);
        buffer.flip();
        this.channel.write(buffer);
        return this;
    }
}

