/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util.messaging;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.response.FailureMessage;
import org.neo4j.driver.internal.messaging.response.IgnoredMessage;
import org.neo4j.driver.internal.messaging.response.RecordMessage;
import org.neo4j.driver.internal.messaging.response.SuccessMessage;

public class MemorizingInboundMessageDispatcher
extends InboundMessageDispatcher {
    private final List<Message> messages = new CopyOnWriteArrayList<Message>();

    public MemorizingInboundMessageDispatcher(Channel channel, Logging logging) {
        super(channel, logging);
    }

    public List<Message> messages() {
        return new ArrayList<Message>(this.messages);
    }

    public void handleSuccessMessage(Map<String, Value> meta) {
        this.messages.add((Message)new SuccessMessage(meta));
    }

    public void handleRecordMessage(Value[] fields) {
        this.messages.add((Message)new RecordMessage(fields));
    }

    public void handleFailureMessage(String code, String message) {
        this.messages.add((Message)new FailureMessage(code, message));
    }

    public void handleIgnoredMessage() {
        this.messages.add((Message)IgnoredMessage.IGNORED);
    }
}

