/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.types.TypeSystem;

class BooleanValueTest {
    private TypeSystem typeSystem = InternalTypeSystem.TYPE_SYSTEM;

    BooleanValueTest() {
    }

    @Test
    void testBooleanTrue() {
        BooleanValue value = BooleanValue.TRUE;
        MatcherAssert.assertThat((Object)value.asBoolean(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)value.isTrue(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)value.isFalse(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    void testBooleanFalse() {
        BooleanValue value = BooleanValue.FALSE;
        MatcherAssert.assertThat((Object)value.asBoolean(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)value.isTrue(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)value.isFalse(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void testIsBoolean() {
        BooleanValue value = BooleanValue.TRUE;
        MatcherAssert.assertThat((Object)this.typeSystem.BOOLEAN().isTypeOf((Value)value), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void testEquals() {
        BooleanValue firstValue = BooleanValue.TRUE;
        BooleanValue secondValue = BooleanValue.TRUE;
        MatcherAssert.assertThat((Object)firstValue, (Matcher)CoreMatchers.equalTo((Object)secondValue));
    }

    @Test
    void testHashCode() {
        BooleanValue value = BooleanValue.TRUE;
        MatcherAssert.assertThat((Object)value.hashCode(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    void shouldNotBeNull() {
        Assertions.assertFalse((boolean)BooleanValue.TRUE.isNull());
        Assertions.assertFalse((boolean)BooleanValue.FALSE.isNull());
    }

    @Test
    void shouldTypeAsBoolean() {
        MatcherAssert.assertThat((Object)BooleanValue.TRUE.typeConstructor(), (Matcher)CoreMatchers.equalTo((Object)TypeConstructor.BOOLEAN));
        MatcherAssert.assertThat((Object)BooleanValue.FALSE.typeConstructor(), (Matcher)CoreMatchers.equalTo((Object)TypeConstructor.BOOLEAN));
    }

    @Test
    void shouldConvertToBooleanAndObject() {
        Assertions.assertTrue((boolean)BooleanValue.TRUE.asBoolean());
        Assertions.assertFalse((boolean)BooleanValue.FALSE.asBoolean());
        MatcherAssert.assertThat((Object)BooleanValue.TRUE.asObject(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)BooleanValue.FALSE.asObject(), (Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE));
    }
}

