/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.BytesValue;
import org.neo4j.driver.types.TypeSystem;

class BytesValueTest {
    private static final byte[] TEST_BYTES = "0123".getBytes();
    private TypeSystem typeSystem = InternalTypeSystem.TYPE_SYSTEM;

    BytesValueTest() {
    }

    @Test
    void testBytesValue() {
        BytesValue value = new BytesValue(TEST_BYTES);
        MatcherAssert.assertThat((Object)value.asObject(), (Matcher)CoreMatchers.equalTo((Object)TEST_BYTES));
    }

    @Test
    void testIsBytes() {
        BytesValue value = new BytesValue(TEST_BYTES);
        MatcherAssert.assertThat((Object)this.typeSystem.BYTES().isTypeOf((Value)value), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void testEquals() {
        BytesValue firstValue = new BytesValue(TEST_BYTES);
        BytesValue secondValue = new BytesValue(TEST_BYTES);
        MatcherAssert.assertThat((Object)firstValue, (Matcher)CoreMatchers.equalTo((Object)secondValue));
    }

    @Test
    void testHashCode() {
        BytesValue value = new BytesValue(TEST_BYTES);
        MatcherAssert.assertThat((Object)value.hashCode(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    void shouldNotBeNull() {
        BytesValue value = new BytesValue(TEST_BYTES);
        Assertions.assertFalse((boolean)value.isNull());
    }

    @Test
    void shouldTypeAsString() {
        BytesValue value = new BytesValue(TEST_BYTES);
        MatcherAssert.assertThat((Object)value.typeConstructor(), (Matcher)CoreMatchers.equalTo((Object)TypeConstructor.BYTES));
    }

    @Test
    void shouldHaveBytesType() {
        BytesValue value = new BytesValue(TEST_BYTES);
        MatcherAssert.assertThat((Object)value.type(), (Matcher)CoreMatchers.equalTo((Object)InternalTypeSystem.TYPE_SYSTEM.BYTES()));
    }
}

