/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.DateTimeValue;

class DateTimeValueTest {
    DateTimeValueTest() {
    }

    @Test
    void shouldHaveCorrectType() {
        ZonedDateTime dateTime = ZonedDateTime.of(1991, 2, 24, 12, 0, 0, 999000, ZoneOffset.ofHours(-5));
        DateTimeValue dateTimeValue = new DateTimeValue(dateTime);
        Assertions.assertEquals((Object)InternalTypeSystem.TYPE_SYSTEM.DATE_TIME(), (Object)dateTimeValue.type());
    }

    @Test
    void shouldSupportAsObject() {
        ZonedDateTime dateTime = ZonedDateTime.of(2015, 8, 2, 23, 59, 59, 999999, ZoneId.of("Europe/Stockholm"));
        DateTimeValue dateTimeValue = new DateTimeValue(dateTime);
        Assertions.assertEquals((Object)dateTime, (Object)dateTimeValue.asObject());
    }

    @Test
    void shouldSupportAsZonedDateTime() {
        ZonedDateTime dateTime = ZonedDateTime.of(1822, 9, 24, 9, 23, 57, 123, ZoneOffset.ofHoursMinutes(12, 15));
        DateTimeValue dateTimeValue = new DateTimeValue(dateTime);
        Assertions.assertEquals((Object)dateTime, (Object)dateTimeValue.asZonedDateTime());
    }

    @Test
    void shouldSupportAsOffsetDateTime() {
        ZonedDateTime dateTimeWithOffset = ZonedDateTime.of(2019, 1, 2, 3, 14, 22, 100, ZoneOffset.ofHours(-5));
        DateTimeValue dateTimeValue1 = new DateTimeValue(dateTimeWithOffset);
        Assertions.assertEquals((Object)dateTimeWithOffset.toOffsetDateTime(), (Object)dateTimeValue1.asOffsetDateTime());
        ZonedDateTime dateTimeWithZoneId = ZonedDateTime.of(2000, 11, 8, 5, 57, 59, 1, ZoneId.of("Europe/Stockholm"));
        DateTimeValue dateTimeValue2 = new DateTimeValue(dateTimeWithZoneId);
        Assertions.assertEquals((Object)dateTimeWithZoneId.toOffsetDateTime(), (Object)dateTimeValue2.asOffsetDateTime());
    }

    @Test
    void shouldNotSupportAsLong() {
        ZonedDateTime dateTime = ZonedDateTime.now();
        DateTimeValue dateTimeValue = new DateTimeValue(dateTime);
        Assertions.assertThrows(Uncoercible.class, () -> ((DateTimeValue)dateTimeValue).asLong());
    }
}

