/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.LocalDateTime;
import java.time.Month;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.LocalDateTimeValue;

class LocalDateTimeValueTest {
    LocalDateTimeValueTest() {
    }

    @Test
    void shouldHaveCorrectType() {
        LocalDateTime dateTime = LocalDateTime.of(1991, Month.AUGUST, 24, 12, 0, 0);
        LocalDateTimeValue dateTimeValue = new LocalDateTimeValue(dateTime);
        Assertions.assertEquals((Object)InternalTypeSystem.TYPE_SYSTEM.LOCAL_DATE_TIME(), (Object)dateTimeValue.type());
    }

    @Test
    void shouldSupportAsObject() {
        LocalDateTime dateTime = LocalDateTime.of(2015, Month.FEBRUARY, 2, 23, 59, 59, 999999);
        LocalDateTimeValue dateTimeValue = new LocalDateTimeValue(dateTime);
        Assertions.assertEquals((Object)dateTime, (Object)dateTimeValue.asObject());
    }

    @Test
    void shouldSupportAsLocalDateTime() {
        LocalDateTime dateTime = LocalDateTime.of(1822, Month.JANUARY, 24, 9, 23, 57, 123);
        LocalDateTimeValue dateTimeValue = new LocalDateTimeValue(dateTime);
        Assertions.assertEquals((Object)dateTime, (Object)dateTimeValue.asLocalDateTime());
    }

    @Test
    void shouldNotSupportAsLong() {
        LocalDateTime dateTime = LocalDateTime.now();
        LocalDateTimeValue dateTimeValue = new LocalDateTimeValue(dateTime);
        Assertions.assertThrows(Uncoercible.class, () -> ((LocalDateTimeValue)dateTimeValue).asLong());
    }
}

