/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.net;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.net.ServerAddress;

class ServerAddressTest {
    ServerAddressTest() {
    }

    @Test
    void shouldCreateAddress() {
        ServerAddress address = ServerAddress.of((String)"my.database.com", (int)8897);
        Assertions.assertEquals((Object)"my.database.com", (Object)address.host());
        Assertions.assertEquals((int)8897, (int)address.port());
    }

    @Test
    void shouldFailToCreateAddressWithInvalidHost() {
        Assertions.assertThrows(NullPointerException.class, () -> ServerAddress.of(null, (int)9999));
    }

    @Test
    void shouldFailToCreateAddressWithInvalidPort() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServerAddress.of((String)"hello.graphs.com", (int)-42));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServerAddress.of((String)"hello.graphs.com", (int)66000));
    }
}

