/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.stress.AbstractAsyncQuery;
import org.neo4j.driver.stress.AbstractContext;

public class AsyncFailingQueryWithRetries<C extends AbstractContext>
extends AbstractAsyncQuery<C> {
    public AsyncFailingQueryWithRetries(Driver driver) {
        super(driver, false);
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        AsyncSession session = this.newSession(AccessMode.READ, context);
        CompletionStage txStage = session.readTransactionAsync(tx -> tx.runAsync("UNWIND [10, 5, 0] AS x RETURN 10 / x").thenCompose(ResultCursor::listAsync));
        CompletionStage<Void> resultsProcessingStage = txStage.handle((records, error) -> {
            Assertions.assertNull((Object)records);
            Throwable cause = Futures.completionExceptionCause((Throwable)error);
            MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.arithmeticError()));
            return null;
        });
        return resultsProcessingStage.whenComplete((nothing, throwable) -> session.closeAsync());
    }
}

