/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.stress.AbstractAsyncQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.Node;

public class AsyncReadQueryWithRetries<C extends AbstractContext>
extends AbstractAsyncQuery<C> {
    public AsyncReadQueryWithRetries(Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        AsyncSession session = this.newSession(AccessMode.READ, context);
        CompletionStage txStage = session.readTransactionAsync(tx -> tx.runAsync("MATCH (n) RETURN n LIMIT 1").thenCompose(cursor -> cursor.nextAsync().thenCompose(record -> this.processRecordAndGetSummary((Record)record, (ResultCursor)cursor))));
        CompletionStage<Void> resultsProcessingStage = txStage.thenApply(resultSummary -> this.processResultSummary((ResultSummary)resultSummary, context));
        return resultsProcessingStage.whenComplete((nothing, throwable) -> session.closeAsync());
    }

    private CompletionStage<ResultSummary> processRecordAndGetSummary(Record record, ResultCursor cursor) {
        if (record != null) {
            Node node = record.get(0).asNode();
            Assertions.assertNotNull((Object)node);
        }
        return cursor.consumeAsync();
    }

    private Void processResultSummary(ResultSummary resultSummary, C context) {
        if (resultSummary != null) {
            ((AbstractContext)context).readCompleted(resultSummary);
        }
        return null;
    }
}

