/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.stress.AbstractBlockingQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.types.Node;

public class BlockingReadQueryInTx<C extends AbstractContext>
extends AbstractBlockingQuery<C> {
    public BlockingReadQueryInTx(Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
    }

    @Override
    public void execute(C context) {
        try (Session session = this.newSession(AccessMode.READ, context);
             Transaction tx = this.beginTransaction(session, context);){
            Result result = tx.run("MATCH (n) RETURN n LIMIT 1");
            List records = result.list();
            if (!records.isEmpty()) {
                Record record = (Record)Iterables.single((Iterable)records);
                Node node = record.get(0).asNode();
                Assertions.assertNotNull((Object)node);
            }
            ((AbstractContext)context).readCompleted(result.consume());
            tx.commit();
        }
    }
}

