/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.stress.AbstractBlockingQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractStressTestBase;

public class BlockingWriteQueryInTx<C extends AbstractContext>
extends AbstractBlockingQuery<C> {
    private AbstractStressTestBase<C> stressTest;

    public BlockingWriteQueryInTx(AbstractStressTestBase<C> stressTest, Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
        this.stressTest = stressTest;
    }

    @Override
    public void execute(C context) {
        Throwable txError;
        Result result;
        block16: {
            result = null;
            txError = null;
            try (Session session = this.newSession(AccessMode.WRITE, context);){
                try (Transaction tx = this.beginTransaction(session, context);){
                    result = tx.run("CREATE ()");
                    tx.commit();
                }
                ((AbstractContext)context).setBookmark(session.lastBookmark());
            }
            catch (Throwable error) {
                txError = error;
                if (this.stressTest.handleWriteFailure(error, context)) break block16;
                throw error;
            }
        }
        if (txError == null && result != null) {
            Assertions.assertEquals((int)1, (int)result.consume().counters().nodesCreated());
            ((AbstractContext)context).nodeCreated();
        }
    }
}

