/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractRxQuery;
import org.neo4j.driver.stress.AbstractStressTestBase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RxWriteQueryWithRetries<C extends AbstractContext>
extends AbstractRxQuery<C> {
    private AbstractStressTestBase<C> stressTest;

    public RxWriteQueryWithRetries(AbstractStressTestBase<C> stressTest, Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
        this.stressTest = stressTest;
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        CompletableFuture<Void> queryFinished = new CompletableFuture<Void>();
        AtomicInteger createdNodesNum = new AtomicInteger();
        Flux.usingWhen((Publisher)Mono.fromSupplier(() -> ((Driver)this.driver).rxSession()), session -> session.writeTransaction(tx -> tx.run("CREATE ()").consume()), session -> Mono.empty(), (session, error) -> session.close(), RxSession::close).subscribe(resultSummary -> createdNodesNum.addAndGet(resultSummary.counters().nodesCreated()), error -> this.handleError(Futures.completionExceptionCause((Throwable)error), context, queryFinished), () -> {
            Assertions.assertEquals((int)1, (int)createdNodesNum.get());
            context.nodeCreated();
            queryFinished.complete(null);
        });
        return queryFinished;
    }

    private void handleError(Throwable error, C context, CompletableFuture<Void> queryFinished) {
        this.stressTest.handleWriteFailure(error, context);
        queryFinished.completeExceptionally(error);
    }
}

