/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.File;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.util.CertificateTool;
import org.neo4j.driver.util.CertificateUtil;

public class CertificateUtilTest {
    @Test
    void shouldLoadMultipleCertsIntoKeyStore() throws Throwable {
        File certFile = File.createTempFile("3random", ".cer");
        certFile.deleteOnExit();
        X509Certificate cert1 = CertificateUtil.generateSelfSignedCertificate();
        X509Certificate cert2 = CertificateUtil.generateSelfSignedCertificate();
        X509Certificate cert3 = CertificateUtil.generateSelfSignedCertificate();
        CertificateTool.saveX509Cert((Certificate[])new Certificate[]{cert1, cert2, cert3}, (File)certFile);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        CertificateTool.loadX509Cert(Collections.singletonList(certFile), (KeyStore)keyStore);
        Enumeration<String> aliases = keyStore.aliases();
        Assertions.assertTrue((boolean)aliases.hasMoreElements());
        Assertions.assertTrue((boolean)aliases.nextElement().startsWith("neo4j.javadriver.trustedcert"));
        Assertions.assertTrue((boolean)aliases.hasMoreElements());
        Assertions.assertTrue((boolean)aliases.nextElement().startsWith("neo4j.javadriver.trustedcert"));
        Assertions.assertTrue((boolean)aliases.hasMoreElements());
        Assertions.assertTrue((boolean)aliases.nextElement().startsWith("neo4j.javadriver.trustedcert"));
        Assertions.assertFalse((boolean)aliases.hasMoreElements());
    }
}

