/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger threadId;

    public DaemonThreadFactory(String namePrefix) {
        this.namePrefix = Objects.requireNonNull(namePrefix);
        this.threadId = new AtomicInteger();
    }

    public static ThreadFactory daemon(String namePrefix) {
        return new DaemonThreadFactory(namePrefix);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName(this.namePrefix + this.threadId.incrementAndGet());
        thread.setDaemon(true);
        return thread;
    }
}

