/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.types.TypeSystem;
import org.neo4j.driver.util.FileTools;
import org.neo4j.driver.util.Neo4jRunner;
import org.neo4j.driver.util.Neo4jSettings;
import org.neo4j.driver.util.TestUtil;

public class DatabaseExtension
implements BeforeEachCallback,
AfterAllCallback {
    static final String TEST_RESOURCE_FOLDER_PATH = "src/test/resources";
    private final Neo4jSettings settings;
    private Neo4jRunner runner;

    public DatabaseExtension() {
        this(Neo4jSettings.TEST_SETTINGS);
    }

    public DatabaseExtension(Neo4jSettings settings) {
        this.settings = settings;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.runner = Neo4jRunner.getOrCreateGlobalRunner();
        this.runner.ensureRunning(this.settings);
        TestUtil.cleanDb(this.driver());
    }

    public void afterAll(ExtensionContext context) {
        if (this.runner != null) {
            this.runner.stopNeo4j();
        }
    }

    public Driver driver() {
        return this.runner.driver();
    }

    public TypeSystem typeSystem() {
        return this.driver().defaultTypeSystem();
    }

    public void forceRestartDb() {
        this.runner.forceToRestart();
    }

    public void restartDb(Neo4jSettings neo4jSettings) {
        this.runner.restartNeo4j(neo4jSettings);
    }

    public URL putTmpFile(String prefix, String suffix, String contents) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix, null);
        tmpFile.deleteOnExit();
        try (PrintWriter out = new PrintWriter(tmpFile);){
            out.println(contents);
        }
        return tmpFile.toURI().toURL();
    }

    public URI uri() {
        return this.runner.boltUri();
    }

    public int httpPort() {
        return this.runner.httpPort();
    }

    public int boltPort() {
        return this.runner.boltPort();
    }

    public AuthToken authToken() {
        return Neo4jRunner.DEFAULT_AUTH_TOKEN;
    }

    public BoltServerAddress address() {
        return this.runner.boltAddress();
    }

    public void updateEncryptionKeyAndCert(File key, File cert) throws Exception {
        FileTools.copyFile(key, this.tlsKeyFile());
        FileTools.copyFile(cert, this.tlsCertFile());
        Neo4jRunner.debug("Updated neo4j key and certificate file.");
        this.runner.forceToRestart();
    }

    public File tlsCertFile() {
        return new File(Neo4jRunner.HOME_DIR, "certificates/neo4j.cert");
    }

    public File tlsKeyFile() {
        return new File(Neo4jRunner.HOME_DIR, "certificates/neo4j.key");
    }

    public void ensureProcedures(String jarName) throws IOException {
        Assumptions.assumeTrue((boolean)this.version().lessThan(ServerVersion.v4_0_0));
        File procedureJar = new File(Neo4jRunner.HOME_DIR, "plugins/" + jarName);
        if (!procedureJar.exists()) {
            FileTools.copyFile(new File(TEST_RESOURCE_FOLDER_PATH, jarName), procedureJar);
            Neo4jRunner.debug("Added a new procedure `%s`", jarName);
            this.runner.forceToRestart();
        }
    }

    public void startDb() {
        this.runner.startNeo4j();
    }

    public void stopDb() {
        this.runner.stopNeo4j();
    }

    public ServerVersion version() {
        return ServerVersion.version((Driver)this.driver());
    }

    public void dumpLogs() {
        this.runner.dumpDebugLog();
    }
}

