/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class FileTools {
    private static final int WINDOWS_RETRY_COUNT = 5;

    public static void deleteRecursively(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File sub : files) {
                FileTools.deleteRecursively(sub);
            }
        }
        file.delete();
    }

    public static File tempFile(String prefix, String suffix) throws Throwable {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        return file;
    }

    public static File tempFile(String prefix) throws Throwable {
        return FileTools.tempFile(prefix, ".tmp");
    }

    public static boolean deleteFile(File file) {
        boolean deleted;
        if (!file.exists()) {
            return true;
        }
        int count = 0;
        do {
            if (deleted = file.delete()) continue;
            ++count;
            FileTools.waitAndThenTriggerGC();
        } while (!deleted && count <= 5);
        return deleted;
    }

    public static void moveFile(File toMove, File target) throws IOException {
        if (!toMove.exists()) {
            throw new FileNotFoundException("Source file[" + toMove.getAbsolutePath() + "] not found");
        }
        if (target.exists()) {
            throw new IOException("Target file[" + target.getAbsolutePath() + "] already exists");
        }
        if (toMove.renameTo(target)) {
            return;
        }
        if (toMove.isDirectory()) {
            Files.createDirectories(target.toPath(), new FileAttribute[0]);
            FileTools.copyRecursively(toMove, target, null);
            FileTools.deleteRecursively(toMove);
        } else {
            FileTools.copyFile(toMove, target);
            FileTools.deleteFile(toMove);
        }
    }

    public static void copyRecursively(File fromDirectory, File toDirectory, FileFilter filter) throws IOException {
        for (File fromFile : fromDirectory.listFiles(filter)) {
            File toFile = new File(toDirectory, fromFile.getName());
            if (fromFile.isDirectory()) {
                Files.createDirectories(toFile.toPath(), new FileAttribute[0]);
                FileTools.copyRecursively(fromFile, toFile, filter);
                continue;
            }
            FileTools.copyFile(fromFile, toFile);
        }
    }

    public static void copyFile(File srcFile, File dstFile) throws IOException {
        File parentFile = dstFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(srcFile);
            output = new FileOutputStream(dstFile);
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new IOException("Could not copy '" + srcFile.getCanonicalPath() + "' to '" + dstFile.getCanonicalPath() + "'", e);
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    private static void waitAndThenTriggerGC() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ee) {
            Thread.interrupted();
        }
        System.gc();
    }

    public static void updateProperty(File propFile, String key, String value) throws IOException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(1);
        propertiesMap.put(key, value);
        FileTools.updateProperties(propFile, propertiesMap, Collections.emptySet());
    }

    public static void updateProperties(File propFile, Map<String, String> propertiesMap, Set<String> excludes) throws IOException {
        Scanner in = new Scanner(propFile);
        HashSet<String> updatedProperties = new HashSet<String>(propertiesMap.size());
        File newPropFile = File.createTempFile(propFile.getName(), null);
        try {
            String value;
            String name;
            FileOutputStream outStream = new FileOutputStream(newPropFile);
            PrintWriter out = new PrintWriter(outStream);
            while (in.hasNextLine()) {
                String line = in.nextLine();
                if (!line.trim().startsWith("#")) {
                    String[] tokens = line.split("=");
                    if (tokens.length == 2) {
                        name = tokens[0].trim();
                        if (excludes.contains(name)) continue;
                        value = propertiesMap.get(name);
                        if (value != null && !updatedProperties.contains(name)) {
                            FileTools.printlnProperty(out, name, value);
                            updatedProperties.add(name);
                            continue;
                        }
                        out.println(line);
                        continue;
                    }
                    out.println(line);
                    continue;
                }
                out.println(line);
            }
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                if (value == null || updatedProperties.contains(name)) continue;
                FileTools.printlnProperty(out, name, value);
            }
            in.close();
            out.flush();
            out.close();
            FileTools.deleteFile(propFile);
            FileTools.moveFile(newPropFile, propFile);
        }
        catch (IOException | RuntimeException e) {
            newPropFile.deleteOnExit();
            throw e;
        }
    }

    private static void printlnProperty(PrintWriter out, String name, Object value) {
        out.print(name);
        out.print('=');
        out.println(value);
    }
}

