/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import org.junit.jupiter.api.Assumptions;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.util.FileTools;
import org.neo4j.driver.util.Neo4jSettings;
import org.neo4j.driver.util.cc.CommandLineUtil;

public class Neo4jRunner {
    private static Neo4jRunner globalInstance;
    private static final String DEFAULT_NEOCTRL_ARGS = "-e 3.5.11";
    private static final String ENV_NEOCTRL_ARGS;
    public static final String NEOCTRL_ARGS;
    public static final Config DEFAULT_CONFIG;
    public static final String USER = "neo4j";
    public static final String PASSWORD = "password";
    public static final AuthToken DEFAULT_AUTH_TOKEN;
    private Neo4jSettings currentSettings = Neo4jSettings.TEST_SETTINGS;
    public static final String TARGET_DIR;
    private static final String NEO4J_DIR;
    public static final String HOME_DIR;
    private Driver driver;
    private boolean restartDriver;

    public int httpPort() {
        return Neo4jSettings.CURRENT_HTTP_PORT;
    }

    public int boltPort() {
        return Neo4jSettings.CURRENT_BOLT_PORT;
    }

    public BoltServerAddress boltAddress() {
        return new BoltServerAddress(this.boltUri());
    }

    public URI boltUri() {
        return URI.create("bolt://localhost:" + this.boltPort());
    }

    public static synchronized Neo4jRunner getOrCreateGlobalRunner() throws IOException {
        Assumptions.assumeTrue((boolean)CommandLineUtil.boltKitAvailable(), (String)"BoltKit support unavailable");
        if (globalInstance == null) {
            globalInstance = new Neo4jRunner();
        }
        return globalInstance;
    }

    public static synchronized boolean globalRunnerExists() {
        return globalInstance != null;
    }

    private Neo4jRunner() throws IOException {
        try {
            this.installNeo4j();
            this.updateServerSettingsFile();
            try {
                this.startNeo4j();
            }
            catch (Exception e) {
                Neo4jRunner.debug("Failed to start server first time due to error: " + ErrorUtil.getRootCause((Throwable)e).getMessage());
                Neo4jRunner.debug("Retry to start server again.");
                this.startNeo4j();
            }
        }
        finally {
            this.installShutdownHook();
        }
    }

    public void ensureRunning(Neo4jSettings neo4jSettings) {
        ServerStatus status = this.serverStatus();
        switch (status) {
            case OFFLINE: {
                this.updateServerSettings(neo4jSettings);
                this.startNeo4j();
                break;
            }
            case ONLINE: {
                this.restartNeo4j(neo4jSettings);
            }
        }
    }

    public Driver driver() {
        if (this.restartDriver) {
            this.restartDriver = false;
            if (this.driver != null) {
                this.driver.close();
                this.driver = null;
            }
        }
        if (this.driver == null) {
            this.driver = GraphDatabase.driver((URI)this.boltUri(), (AuthToken)DEFAULT_AUTH_TOKEN, (Config)DEFAULT_CONFIG);
        }
        return this.driver;
    }

    private void installNeo4j() throws IOException {
        File targetHomeFile = new File(HOME_DIR);
        if (targetHomeFile.exists()) {
            Neo4jRunner.debug("Found and using server installed at `%s`. ", HOME_DIR);
        } else {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("neoctrl-install");
            String[] split = NEOCTRL_ARGS.trim().split("\\s+");
            commands.addAll(Arrays.asList(split));
            commands.add(NEO4J_DIR);
            String tempHomeDir = CommandLineUtil.executeCommand(commands).trim();
            Neo4jRunner.debug("Downloaded server at `%s`, now renaming to `%s`.", tempHomeDir, HOME_DIR);
            FileTools.moveFile(new File(tempHomeDir), targetHomeFile);
            Neo4jRunner.debug("Installed server at `%s`.", HOME_DIR);
            CommandLineUtil.executeCommand("neoctrl-create-user", HOME_DIR, USER, PASSWORD);
        }
    }

    public void startNeo4j() {
        Neo4jRunner.debug("Starting server...");
        CommandLineUtil.executeCommand("neoctrl-start", HOME_DIR, "-v");
        Neo4jRunner.debug("Server started.");
    }

    public synchronized void stopNeo4j() {
        if (this.serverStatus() == ServerStatus.OFFLINE) {
            return;
        }
        this.restartDriver = true;
        Neo4jRunner.debug("Stopping server...");
        CommandLineUtil.executeCommand("neoctrl-stop", HOME_DIR);
        Neo4jRunner.debug("Server stopped.");
    }

    public void killNeo4j() {
        if (this.serverStatus() == ServerStatus.OFFLINE) {
            return;
        }
        this.restartDriver = true;
        Neo4jRunner.debug("Killing server...");
        CommandLineUtil.executeCommand("neoctrl-stop", "-k", HOME_DIR);
        Neo4jRunner.debug("Server killed.");
    }

    public void forceToRestart() {
        this.stopNeo4j();
        this.startNeo4j();
    }

    public void restartNeo4j() {
        this.restartNeo4j(Neo4jSettings.TEST_SETTINGS);
    }

    public void restartNeo4j(Neo4jSettings neo4jSettings) {
        if (this.updateServerSettings(neo4jSettings)) {
            this.forceToRestart();
        }
    }

    public void dumpDebugLog() {
        try {
            System.out.println("Debug log for: " + HOME_DIR);
            Scanner input = new Scanner(new File(HOME_DIR + "/logs/debug.log"));
            while (input.hasNextLine()) {
                System.out.println(input.nextLine());
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Unable to find debug log file for: " + HOME_DIR);
            e.printStackTrace();
        }
    }

    private ServerStatus serverStatus() {
        try {
            SocketChannel soChannel = SocketChannel.open();
            soChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            BoltServerAddress address = this.boltAddress();
            soChannel.connect(new InetSocketAddress(address.connectionHost(), address.port()));
            soChannel.close();
            return ServerStatus.ONLINE;
        }
        catch (IOException e) {
            return ServerStatus.OFFLINE;
        }
    }

    private boolean updateServerSettings(Neo4jSettings newSetting) {
        if (this.currentSettings.equals(newSetting)) {
            return false;
        }
        this.currentSettings = newSetting;
        this.updateServerSettingsFile();
        return true;
    }

    private void updateServerSettingsFile() {
        Map<String, String> propertiesMap = this.currentSettings.propertiesMap();
        if (propertiesMap.isEmpty()) {
            return;
        }
        File oldFile = new File(HOME_DIR, "conf/neo4j.conf");
        try {
            Neo4jRunner.debug("Changing server properties file (for next start): %s", oldFile.getCanonicalPath());
            for (Map.Entry<String, String> property : propertiesMap.entrySet()) {
                String name = property.getKey();
                String value = property.getValue();
                Neo4jRunner.debug("%s=%s", name, value);
            }
            FileTools.updateProperties(oldFile, propertiesMap, this.currentSettings.excludes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void installShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Neo4jRunner.debug("Starting shutdown hook");
                if (this.driver != null) {
                    this.driver.close();
                }
                this.stopNeo4j();
                Neo4jRunner.debug("Finished shutdown hook");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    public static void debug(String text, Object ... args) {
        System.out.println(String.format(text, args));
    }

    public static void debug(String text) {
        System.out.println(text);
    }

    static {
        ENV_NEOCTRL_ARGS = System.getenv("JAVA_DRIVER_NEOCTRL_ARGS");
        NEOCTRL_ARGS = System.getProperty("neoctrl.args", ENV_NEOCTRL_ARGS == null ? DEFAULT_NEOCTRL_ARGS : ENV_NEOCTRL_ARGS);
        DEFAULT_CONFIG = Config.builder().withLogging(Logging.console((Level)Level.INFO)).withoutEncryption().build();
        DEFAULT_AUTH_TOKEN = AuthTokens.basic((String)USER, (String)PASSWORD);
        TARGET_DIR = new File("../target").getAbsolutePath();
        NEO4J_DIR = new File(TARGET_DIR, "test-server-" + Neo4jSettings.TEST_JVM_ID).getAbsolutePath();
        HOME_DIR = new File(NEO4J_DIR, "neo4jHome").getAbsolutePath();
    }

    private static enum ServerStatus {
        ONLINE,
        OFFLINE;

    }
}

