/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.nio.file.Path;
import org.neo4j.driver.util.cc.CommandLineUtil;

final class ClusterControl {
    private ClusterControl() {
    }

    static void installCluster(String neo4jVersion, int cores, int readReplicas, String password, int port, Path path) {
        CommandLineUtil.executeCommand("neoctrl-cluster", "install", "--cores", String.valueOf(cores), "--read-replicas", String.valueOf(readReplicas), "--password", password, "--initial-port", String.valueOf(port), neo4jVersion, path.toString());
    }

    static String startCluster(Path path) {
        return CommandLineUtil.executeCommand("neoctrl-cluster", "start", path.toString());
    }

    static String startClusterMember(Path path) {
        return CommandLineUtil.executeCommand("neoctrl-start", path.toString());
    }

    static void stopCluster(Path path) {
        CommandLineUtil.executeCommand("neoctrl-cluster", "stop", path.toString());
    }

    static void killCluster(Path path) {
        CommandLineUtil.executeCommand("neoctrl-cluster", "stop", "--kill", path.toString());
    }
}

