/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.util.cc.ClusterMember;
import org.neo4j.driver.util.cc.ClusterMemberRoleDiscoveryFactory;

public class ClusterDrivers
implements AutoCloseable {
    private final String user;
    private final String password;
    private final Map<ClusterMember, Driver> membersWithDrivers;
    private ClusterMemberRoleDiscoveryFactory.ClusterMemberRoleDiscovery discovery;

    public ClusterDrivers(String user, String password) {
        this.user = user;
        this.password = password;
        this.membersWithDrivers = new ConcurrentHashMap<ClusterMember, Driver>();
    }

    public Driver getDriver(ClusterMember member) {
        Driver driver = this.membersWithDrivers.computeIfAbsent(member, this::createDriver);
        if (this.discovery == null) {
            this.discovery = ClusterMemberRoleDiscoveryFactory.newInstance(ServerVersion.version((Driver)driver));
        }
        return driver;
    }

    public ClusterMemberRoleDiscoveryFactory.ClusterMemberRoleDiscovery getDiscovery() {
        return this.discovery;
    }

    @Override
    public void close() {
        for (Driver driver : this.membersWithDrivers.values()) {
            driver.close();
        }
    }

    private Driver createDriver(ClusterMember member) {
        return GraphDatabase.driver((URI)member.getBoltUri(), (AuthToken)AuthTokens.basic((String)this.user, (String)this.password), (Config)ClusterDrivers.driverConfig());
    }

    private static Config driverConfig() {
        return Config.builder().withLogging(DevNullLogging.DEV_NULL_LOGGING).withoutEncryption().withMaxConnectionPoolSize(1).withConnectionLivenessCheckTimeout(0L, TimeUnit.MILLISECONDS).withEventLoopThreads(1).build();
    }
}

