/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.util.cc.ClusterMemberRole;

public class ClusterMemberRoleDiscoveryFactory {
    public static ClusterMemberRoleDiscovery newInstance(ServerVersion version) {
        if (version.greaterThanOrEqual(ServerVersion.v4_0_0)) {
            return new SimpleClusterMemberRoleDiscovery();
        }
        return new LegacyClusterMemberRoleDiscovery();
    }

    private static ClusterMemberRole extractRoleForDatabase(Record record, String database) {
        Map databases = record.get("databases").asMap(Values.ofString());
        String roleString = (String)databases.get(database);
        return ClusterMemberRole.valueOf(roleString.toUpperCase());
    }

    private static BoltServerAddress extractBoltAddress(Record record) {
        List addresses = record.get("addresses").asList();
        String boltUriString = (String)addresses.get(0);
        URI boltUri = URI.create(boltUriString);
        return ClusterMemberRoleDiscoveryFactory.newBoltServerAddress(boltUri);
    }

    private static BoltServerAddress newBoltServerAddress(URI uri) {
        try {
            return new BoltServerAddress(InetAddress.getByName(uri.getHost()).getHostAddress(), uri.getPort());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to resolve host to IP in URI: '" + uri + "'");
        }
    }

    private static ClusterMemberRole extractRole(Record record) {
        String roleString = record.get("role").asString();
        return ClusterMemberRole.valueOf(roleString.toUpperCase());
    }

    public static class SimpleClusterMemberRoleDiscovery
    implements ClusterMemberRoleDiscovery {
        private static final String DEFAULT_DATABASE = "neo4j";

        @Override
        public boolean isCoreMember(Driver driver) {
            try (Session session = driver.session(SessionConfig.builder().withDefaultAccessMode(AccessMode.READ).build());){
                Record record = (Record)Iterables.single((Iterable)session.run("CALL dbms.cluster.role($database)", Values.parameters((Object[])new Object[]{"database", DEFAULT_DATABASE})).list());
                ClusterMemberRole role = ClusterMemberRoleDiscoveryFactory.extractRole(record);
                boolean bl = role == ClusterMemberRole.LEADER || role == ClusterMemberRole.FOLLOWER;
                return bl;
            }
        }

        @Override
        public Map<BoltServerAddress, ClusterMemberRole> findClusterOverview(Driver driver) {
            try (Session session = driver.session(SessionConfig.builder().withDefaultAccessMode(AccessMode.READ).build());){
                Result result = session.run("CALL dbms.cluster.overview()");
                HashMap<BoltServerAddress, ClusterMemberRole> overview = new HashMap<BoltServerAddress, ClusterMemberRole>();
                for (Record record : result.list()) {
                    BoltServerAddress address = ClusterMemberRoleDiscoveryFactory.extractBoltAddress(record);
                    ClusterMemberRole role = ClusterMemberRoleDiscoveryFactory.extractRoleForDatabase(record, DEFAULT_DATABASE);
                    if (role == ClusterMemberRole.UNKNOWN) continue;
                    overview.put(address, role);
                }
                HashMap<BoltServerAddress, ClusterMemberRole> hashMap = overview;
                return hashMap;
            }
        }
    }

    public static class LegacyClusterMemberRoleDiscovery
    implements ClusterMemberRoleDiscovery {
        @Override
        public boolean isCoreMember(Driver driver) {
            try (Session session = driver.session(SessionConfig.builder().withDefaultAccessMode(AccessMode.READ).build());){
                Record record = (Record)Iterables.single((Iterable)session.run("CALL dbms.cluster.role()").list());
                ClusterMemberRole role = ClusterMemberRoleDiscoveryFactory.extractRole(record);
                boolean bl = role == ClusterMemberRole.LEADER || role == ClusterMemberRole.FOLLOWER;
                return bl;
            }
        }

        @Override
        public Map<BoltServerAddress, ClusterMemberRole> findClusterOverview(Driver driver) {
            try (Session session = driver.session(SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build());){
                Result result = session.run("CALL dbms.cluster.overview()");
                HashMap<BoltServerAddress, ClusterMemberRole> overview = new HashMap<BoltServerAddress, ClusterMemberRole>();
                for (Record record : result.list()) {
                    BoltServerAddress address = ClusterMemberRoleDiscoveryFactory.extractBoltAddress(record);
                    ClusterMemberRole role = ClusterMemberRoleDiscoveryFactory.extractRole(record);
                    overview.put(address, role);
                }
                HashMap<BoltServerAddress, ClusterMemberRole> hashMap = overview;
                return hashMap;
            }
        }
    }

    public static interface ClusterMemberRoleDiscovery {
        public boolean isCoreMember(Driver var1);

        public Map<BoltServerAddress, ClusterMemberRole> findClusterOverview(Driver var1);
    }
}

