/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.util.DaemonThreadFactory;
import org.neo4j.driver.util.ProcessEnvConfigurator;
import org.neo4j.driver.util.cc.CommandLineException;

public class CommandLineUtil {
    private static final ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory("command-line-thread-"));

    public static boolean boltKitAvailable() {
        try {
            CommandLineUtil.executeCommand("neoctrl-cluster", "--help");
            return true;
        }
        catch (CommandLineException e) {
            return false;
        }
    }

    public static String executeCommand(List<String> commands) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(commands);
            ProcessEnvConfigurator.configure(processBuilder);
            return CommandLineUtil.executeAndGetStdOut(processBuilder);
        }
        catch (IOException | CommandLineException e) {
            throw new CommandLineException("Error running command " + commands, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandLineException("Interrupted while waiting for command " + commands, e);
        }
    }

    public static String executeCommand(String ... command) {
        return CommandLineUtil.executeCommand(Arrays.asList(command));
    }

    private static String executeAndGetStdOut(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        Process process = processBuilder.start();
        Future<String> stdOutFuture = CommandLineUtil.read(process.getInputStream());
        Future<String> stdErrFuture = CommandLineUtil.read(process.getErrorStream());
        int exitCode = process.waitFor();
        String stdOut = CommandLineUtil.get(stdOutFuture);
        String stdErr = CommandLineUtil.get(stdErrFuture);
        if (exitCode != 0) {
            throw new CommandLineException("Non-zero exit code\nSTDOUT:\n" + stdOut + "\nSTDERR:\n" + stdErr);
        }
        return stdOut;
    }

    private static Future<String> read(final InputStream input) {
        return executor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return CommandLineUtil.readToString(input);
            }
        });
    }

    private static String readToString(InputStream input) {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new CommandLineException("Unable to read from stream", e);
        }
        return result.toString();
    }

    private static <T> T get(Future<T> future) {
        try {
            return future.get(10L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

