/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.net.URI;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.util.TestUtil;
import org.neo4j.driver.util.cc.ClusterExtension;

public class LocalOrRemoteClusterExtension
implements BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    private static final String CLUSTER_URI_SYSTEM_PROPERTY_NAME = "externalClusterUri";
    private static final String NEO4J_USER_PASSWORD_PROPERTY_NAME = "neo4jUserPassword";
    private ClusterExtension localClusterExtension;
    private URI clusterUri;

    public LocalOrRemoteClusterExtension() {
        LocalOrRemoteClusterExtension.assertValidSystemPropertiesDefined();
    }

    public URI getClusterUri() {
        return this.clusterUri;
    }

    public AuthToken getAuthToken() {
        if (LocalOrRemoteClusterExtension.remoteClusterExists()) {
            return AuthTokens.basic((String)"neo4j", (String)LocalOrRemoteClusterExtension.neo4jUserPasswordFromSystemProperty());
        }
        return this.localClusterExtension.getDefaultAuthToken();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (LocalOrRemoteClusterExtension.remoteClusterExists()) {
            this.clusterUri = LocalOrRemoteClusterExtension.remoteClusterUriFromSystemProperty();
            this.deleteDataInRemoteCluster();
        } else {
            this.localClusterExtension = new ClusterExtension();
            this.localClusterExtension.beforeAll(context);
            this.clusterUri = this.localClusterExtension.getCluster().getRoutingUri();
        }
    }

    public void afterEach(ExtensionContext context) {
        if (LocalOrRemoteClusterExtension.remoteClusterExists()) {
            this.deleteDataInRemoteCluster();
        } else {
            this.localClusterExtension.afterEach(context);
        }
    }

    public void afterAll(ExtensionContext context) {
        if (!LocalOrRemoteClusterExtension.remoteClusterExists()) {
            this.localClusterExtension.afterAll(context);
        }
    }

    public void dumpClusterLogs() {
        if (this.localClusterExtension != null) {
            this.localClusterExtension.getCluster().dumpClusterDebugLog();
        }
    }

    private void deleteDataInRemoteCluster() {
        Config.ConfigBuilder builder = Config.builder();
        builder.withEventLoopThreads(1);
        try (Driver driver = GraphDatabase.driver((URI)this.getClusterUri(), (AuthToken)this.getAuthToken(), (Config)builder.build());){
            TestUtil.cleanDb(driver);
        }
    }

    private static void assertValidSystemPropertiesDefined() {
        URI uri = LocalOrRemoteClusterExtension.remoteClusterUriFromSystemProperty();
        String password = LocalOrRemoteClusterExtension.neo4jUserPasswordFromSystemProperty();
        if (uri != null && password == null || uri == null && password != null) {
            throw new IllegalStateException("Both cluster uri and 'neo4j' user password system properties should be set. Uri: '" + uri + "', Password: '" + password + "'");
        }
    }

    private static boolean remoteClusterExists() {
        return LocalOrRemoteClusterExtension.remoteClusterUriFromSystemProperty() != null;
    }

    private static URI remoteClusterUriFromSystemProperty() {
        String uri = System.getProperty(CLUSTER_URI_SYSTEM_PROPERTY_NAME);
        return uri == null ? null : URI.create(uri);
    }

    private static String neo4jUserPasswordFromSystemProperty() {
        return System.getProperty(NEO4J_USER_PASSWORD_PROPERTY_NAME);
    }
}

