/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.driver.util.Neo4jRunner;
import org.neo4j.driver.util.cc.Cluster;
import org.neo4j.driver.util.cc.ClusterControl;
import org.neo4j.driver.util.cc.ClusterMember;
import org.neo4j.driver.util.cc.ClusterUnavailableException;

final class SharedCluster {
    private static Cluster clusterInstance;

    private SharedCluster() {
    }

    static Cluster get() {
        SharedCluster.assertClusterExists();
        return clusterInstance;
    }

    static void remove() {
        SharedCluster.assertClusterExists();
        clusterInstance.close();
        clusterInstance = null;
    }

    static boolean exists() {
        return clusterInstance != null;
    }

    static void install(String neo4jVersion, int cores, int readReplicas, String password, int port, Path path) {
        SharedCluster.assertClusterDoesNotExist();
        if (Files.isDirectory(path, new LinkOption[0])) {
            Neo4jRunner.debug("Found and using cluster installed at `%s`.", path);
        } else {
            ClusterControl.installCluster(neo4jVersion, cores, readReplicas, password, port, path);
            Neo4jRunner.debug("Downloaded cluster at `%s`.", path);
        }
        clusterInstance = new Cluster(path, password);
    }

    static void start() throws ClusterUnavailableException {
        SharedCluster.assertClusterExists();
        String output = ClusterControl.startCluster(clusterInstance.getPath());
        Set<ClusterMember> members = SharedCluster.parseStartCommandOutput(output);
        try {
            clusterInstance = clusterInstance.withMembers(members);
            Neo4jRunner.debug("Cluster started: %s.", members);
        }
        catch (ClusterUnavailableException e) {
            SharedCluster.kill();
            throw e;
        }
    }

    static void start(ClusterMember member) {
        SharedCluster.assertClusterExists();
        ClusterControl.startClusterMember(member.getPath());
        Neo4jRunner.debug("Cluster member at `%s` started.", member);
    }

    static void stop() {
        SharedCluster.assertClusterExists();
        ClusterControl.stopCluster(clusterInstance.getPath());
        Neo4jRunner.debug("Cluster at `%s` stopped.", clusterInstance.getPath());
    }

    static void kill() {
        SharedCluster.assertClusterExists();
        ClusterControl.killCluster(clusterInstance.getPath());
        Neo4jRunner.debug("Cluster at `%s` killed.", clusterInstance.getPath());
    }

    private static Set<ClusterMember> parseStartCommandOutput(String output) {
        HashSet<ClusterMember> result = new HashSet<ClusterMember>();
        String[] lines = output.split(System.lineSeparator());
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.isEmpty()) continue;
            String[] clusterMemberSplit = line.split(" ");
            if (clusterMemberSplit.length != 3) {
                throw new IllegalArgumentException(String.format("Wrong start command output found at line [%s]. Expected to have 'http_uri bolt_uri path' on each nonempty line. Command output:%n`%s`", i + 1, output));
            }
            URI boltUri = URI.create(clusterMemberSplit[1]);
            Path path = Paths.get(clusterMemberSplit[2], new String[0]);
            result.add(new ClusterMember(boltUri, path));
        }
        if (result.isEmpty()) {
            throw new IllegalStateException("No cluster members");
        }
        return result;
    }

    private static void assertClusterExists() {
        if (clusterInstance == null) {
            throw new IllegalStateException("Shared cluster does not exist");
        }
    }

    private static void assertClusterDoesNotExist() {
        if (clusterInstance != null) {
            throw new IllegalStateException("Shared cluster already exists");
        }
    }
}

