/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.XmlReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultXmlPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Description(value="A MAB XML reader")
@In(value=XmlReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="handle-mabxml")
public final class AlephMabXmlHandler
extends DefaultXmlPipe<StreamReceiver> {
    private static final String SUBFIELD = "subfield";
    private static final String DATAFIELD = "datafield";
    private static final String CONTROLLFIELD = "controlfield";
    private static final String RECORD = "ListRecords";
    private static final String LEADER = "leader";
    private static final String DATAFIELD_ATTRIBUTE = "tag";
    private static final String SUBFIELD_ATTRIBUTE = "code";
    private static final String INDICATOR1 = "ind1";
    private static final String INDICATOR2 = "ind2";
    private String currentTag = "";
    private StringBuilder builder = new StringBuilder();

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.builder.append(chars, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (CONTROLLFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).literal(this.currentTag, this.builder.toString().trim());
            ((StreamReceiver)this.getReceiver()).endEntity();
        } else if (SUBFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).literal(this.currentTag, this.builder.toString().trim());
        } else if (DATAFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).endEntity();
        } else if (RECORD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (CONTROLLFIELD.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = "";
            ((StreamReceiver)this.getReceiver()).startEntity(attributes.getValue(DATAFIELD_ATTRIBUTE));
        } else if (SUBFIELD.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = attributes.getValue(SUBFIELD_ATTRIBUTE);
        } else if (DATAFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).startEntity(attributes.getValue(DATAFIELD_ATTRIBUTE) + attributes.getValue(INDICATOR1) + attributes.getValue(INDICATOR2));
        } else if (RECORD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).startRecord("");
        } else if (LEADER.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = LEADER;
        }
    }
}

