/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Parses a raw Aseq record (UTF-8 encoding expected).")
@In(value=String.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="decode-aseq")
public final class AseqDecoder
extends DefaultObjectPipe<String, StreamReceiver> {
    private static final String FIELD_DELIMITER = "\n";
    private static final int CATEGORY_BEGIN = 10;
    private static final int CATEGORY_END = 15;
    private static final int FIELD_CONTENT_BEGIN = 18;
    private static final int RECORD_IDENTIFIER_BEGIN = 0;
    private static final int RECORD_IDENTIFIER_END = 9;

    public void process(String record) {
        assert (!this.isClosed());
        String trimedRecord = record.trim();
        if (trimedRecord.isEmpty()) {
            return;
        }
        String[] lines = trimedRecord.split(FIELD_DELIMITER);
        for (int i = 0; i < lines.length; ++i) {
            String[] subfields;
            String field = lines[i];
            if (i == 0) {
                ((StreamReceiver)this.getReceiver()).startRecord(field.substring(0, 9));
            }
            String category = field.substring(10, 15).trim();
            String fieldContent = field.substring(18).trim();
            if (!fieldContent.startsWith("$$")) {
                ((StreamReceiver)this.getReceiver()).literal(category, fieldContent);
                continue;
            }
            ((StreamReceiver)this.getReceiver()).startEntity(category);
            for (String subfield : subfields = fieldContent.split("\\$\\$")) {
                if (subfield.isEmpty()) continue;
                ((StreamReceiver)this.getReceiver()).literal(subfield.substring(0, 1), subfield.substring(1));
            }
            ((StreamReceiver)this.getReceiver()).endEntity();
        }
        ((StreamReceiver)this.getReceiver()).endRecord();
    }
}

