/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio;

import java.util.ArrayList;
import java.util.List;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.XmlReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultXmlPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Description(value="A comarc xml reader")
@In(value=XmlReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="handle-comarcxml")
public class ComarcXmlHandler
extends DefaultXmlPipe<StreamReceiver> {
    private static final String SUBFIELD = "subfield";
    private static final String DATAFIELD = "datafield";
    private static final String RECORD = "record";
    private static final String NAMESPACE = "http://www.loc.gov/MARC21/slim";
    private static final int RECORD_NOT_INITIALISED = 0;
    private static final int RECORD_INITIALISED = 1;
    private final List<Entry> subfieldValues = new ArrayList<Entry>();
    private int state = 0;
    private String currentTag = "";
    private StringBuilder builder = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (SUBFIELD.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = attributes.getValue("code");
        } else if (DATAFIELD.equals(localName) && this.state == 1) {
            ((StreamReceiver)this.getReceiver()).startEntity(attributes.getValue("tag") + attributes.getValue("ind1") + attributes.getValue("ind2"));
        } else if (RECORD.equals(localName) && NAMESPACE.equals(uri)) {
            this.state = 0;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        block7: {
            block8: {
                block6: {
                    if (!SUBFIELD.equals(localName)) break block6;
                    this.subfieldValues.add(new Entry(this.currentTag, this.builder.toString().trim()));
                    break block7;
                }
                if (!DATAFIELD.equals(localName)) break block8;
                switch (this.state) {
                    case 0: {
                        ((StreamReceiver)super.getReceiver()).startRecord(this.getFirstSubfield("x"));
                        ((StreamReceiver)super.getReceiver()).startEntity("000  ");
                        this.state = 1;
                    }
                    case 1: {
                        for (Entry entry : this.subfieldValues) {
                            ((StreamReceiver)super.getReceiver()).literal(entry.getKey(), entry.getValue());
                        }
                        ((StreamReceiver)super.getReceiver()).endEntity();
                        this.subfieldValues.clear();
                        break block7;
                    }
                    default: {
                        throw new SAXException("State was not one of initialised or not initialised");
                    }
                }
            }
            if (RECORD.equals(localName) && NAMESPACE.equals(uri)) {
                ((StreamReceiver)this.getReceiver()).endRecord();
            }
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.builder.append(chars, start, length);
    }

    private String getFirstSubfield(String subfieldCode) {
        String ret = null;
        for (Entry entry : this.subfieldValues) {
            if (!subfieldCode.equals(entry.getKey())) continue;
            ret = entry.getValue();
            break;
        }
        return ret;
    }

    private class Entry {
        private final String key;
        private final String value;

        Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        private String getKey() {
            return this.key;
        }

        private String getValue() {
            return this.value;
        }
    }
}

