/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio;

import java.util.regex.Pattern;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.FormatException;
import org.metafacture.framework.MissingIdException;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Parses a raw Mab2 stream (UTF-8 encoding expected).")
@In(value=String.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="decode-mab")
public final class MabDecoder
extends DefaultObjectPipe<String, StreamReceiver> {
    private static final String FIELD_END = "\u001e";
    private static final Pattern FIELD_PATTERN = Pattern.compile("\u001e", 16);
    private static final Pattern SUBFIELD_PATTERN = Pattern.compile("\u001f", 16);
    private static final String RECORD_END = "\u001d";
    private static final int FIELD_NAME_SIZE = 4;
    private static final int HEADER_SIZE = 24;
    private static final String LEADER = "Leader";
    private static final String TYPE = "type";
    private static final String INVALID_FORMAT = "Invalid MAB format";
    private static final String ID_TAG = "001 ";
    private static final int TAG_LENGTH = 4;

    public void process(String record) {
        assert (!this.isClosed());
        if (record.trim().isEmpty()) {
            return;
        }
        ((StreamReceiver)this.getReceiver()).startRecord(this.extractIdFromRecord(record));
        try {
            ((StreamReceiver)this.getReceiver()).literal(LEADER, record.substring(0, 24));
            ((StreamReceiver)this.getReceiver()).literal(TYPE, String.valueOf(record.charAt(23)));
            String content = record.substring(24);
            for (String part : FIELD_PATTERN.split(content)) {
                if (part.startsWith(RECORD_END)) continue;
                String fieldName = part.substring(0, 4).trim();
                String fieldContent = part.substring(4);
                String[] subFields = SUBFIELD_PATTERN.split(fieldContent);
                if (subFields.length == 1) {
                    ((StreamReceiver)this.getReceiver()).literal(fieldName, subFields[0]);
                    continue;
                }
                ((StreamReceiver)this.getReceiver()).startEntity(fieldName);
                for (int i = 1; i < subFields.length; ++i) {
                    String name = subFields[i].substring(0, 1);
                    String value = subFields[i].substring(1);
                    ((StreamReceiver)this.getReceiver()).literal(name, value);
                }
                ((StreamReceiver)this.getReceiver()).endEntity();
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FormatException("[" + record + "]", (Throwable)e);
        }
        ((StreamReceiver)this.getReceiver()).endRecord();
    }

    private String extractIdFromRecord(String record) {
        try {
            int fieldEnd = record.indexOf(FIELD_END, 24);
            if (record.substring(24, 28).equals(ID_TAG)) {
                return record.substring(28, fieldEnd);
            }
            throw new MissingIdException(record);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FormatException(INVALID_FORMAT + record, (Throwable)e);
        }
    }
}

