/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathException;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.oclc.oai.harvester2.app.RawWrite;
import org.xml.sax.SAXException;

@Description(value="Opens an OAI-PMH stream and passes a reader to the receiver. Mandatory arguments are: BASE_URL, DATE_FROM, DATE_UNTIL, METADATA_PREFIX, SET_SPEC .")
@In(value=String.class)
@Out(value=Reader.class)
public final class OaiPmhOpener
extends DefaultObjectPipe<String, ObjectReceiver<Reader>> {
    private String encoding = "UTF-8";
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private String dateFrom;
    private String dateUntil;
    private String setSpec;
    private String metadataPrefix;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public void setDateUntil(String dateUntil) {
        this.dateUntil = dateUntil;
    }

    public void setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    public void setSetSpec(String setSpec) {
        this.setSpec = setSpec;
    }

    public void process(String baseUrl) {
        try {
            RawWrite.run((String)baseUrl, (String)this.dateFrom, (String)this.dateUntil, (String)this.metadataPrefix, (String)this.setSpec, (OutputStream)this.outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (XPathException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        try {
            ((ObjectReceiver)this.getReceiver()).process((Object)new InputStreamReader((InputStream)new ByteArrayInputStream(this.outputStream.toByteArray()), this.encoding));
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }
}

